/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BufferedHttpResponse
extends HttpResponse {
    private final HttpResponse innerHttpResponse;
    private final Flux<ByteBuffer> cachedBody;

    public BufferedHttpResponse(HttpResponse innerHttpResponse) {
        super(innerHttpResponse.getRequest());
        this.innerHttpResponse = innerHttpResponse;
        this.cachedBody = FluxUtil.collectBytesInByteBufferStream(innerHttpResponse.getBody()).map(ByteBuffer::wrap).flux().cache();
    }

    @Override
    public int getStatusCode() {
        return this.innerHttpResponse.getStatusCode();
    }

    @Override
    public String getHeaderValue(String name) {
        return this.innerHttpResponse.getHeaderValue(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.innerHttpResponse.getHeaders();
    }

    @Override
    public Flux<ByteBuffer> getBody() {
        return this.cachedBody;
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        return this.cachedBody.next().map(ByteBuffer::array);
    }

    @Override
    public Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString(bytes, this.innerHttpResponse.getHeaderValue("Content-Type")));
    }

    @Override
    public Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> bytes == null ? null : new String((byte[])bytes, charset));
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}

