/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.util.Beta;
import reactor.core.publisher.Mono;

@Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class CosmosAsyncClientEncryptionKey {
    private final CosmosAsyncDatabase database;
    private String id;

    CosmosAsyncClientEncryptionKey(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getId() {
        return this.id;
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<CosmosClientEncryptionKeyResponse> read() {
        return FluxUtil.withContext(context -> this.readInternal((Context)context, null));
    }

    Mono<CosmosClientEncryptionKeyResponse> read(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.readInternal((Context)context, requestOptions));
    }

    private Mono<CosmosClientEncryptionKeyResponse> readInternal(Context context, RequestOptions requestOptions) {
        String spanName = "readClientEncryptionKey." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().readClientEncryptionKey(this.getLink(), requestOptions).map(response -> ModelBridgeInternal.createCosmosClientEncryptionKeyResponse(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<CosmosClientEncryptionKeyResponse> replace(CosmosClientEncryptionKeyProperties keyProperties) {
        return FluxUtil.withContext(context -> this.replaceInternal(keyProperties, (Context)context));
    }

    private Mono<CosmosClientEncryptionKeyResponse> replaceInternal(CosmosClientEncryptionKeyProperties keyProperties, Context context) {
        String spanName = "replaceClientEncryptionKey." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().replaceClientEncryptionKey(ModelBridgeInternal.getClientEncryptionKey(keyProperties), this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosClientEncryptionKeyResponse(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    String getURIPathSegment() {
        return "clientencryptionkeys";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosAsyncClientEncryptionKeyHelper.setCosmosAsyncClientEncryptionKeyAccessor((cosmosAsyncClientEncryptionKey, requestOptions) -> cosmosAsyncClientEncryptionKey.read(requestOptions));
    }

    static {
        CosmosAsyncClientEncryptionKey.initialize();
    }
}

