/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncTrigger {
    private final CosmosAsyncContainer container;
    private String id;

    CosmosAsyncTrigger(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncTrigger setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosTriggerResponse> read() {
        return FluxUtil.withContext(context -> this.readInternal((Context)context));
    }

    public Mono<CosmosTriggerResponse> replace(CosmosTriggerProperties triggerProperties) {
        return FluxUtil.withContext(context -> this.replaceInternal(triggerProperties, (Context)context));
    }

    public Mono<CosmosTriggerResponse> delete() {
        return FluxUtil.withContext(context -> this.deleteInternal((Context)context));
    }

    String getURIPathSegment() {
        return "triggers";
    }

    String getParentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    private Mono<CosmosTriggerResponse> readInternal(Context context) {
        String spanName = "readTrigger." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().readTrigger(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosTriggerResponse(response)).single();
        return this.container.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosTriggerResponse> replaceInternal(CosmosTriggerProperties triggerSettings, Context context) {
        String spanName = "replaceTrigger." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().replaceTrigger(new Trigger(ModelBridgeInternal.toJsonFromJsonSerializable(ModelBridgeInternal.getResource(triggerSettings))), null).map(response -> ModelBridgeInternal.createCosmosTriggerResponse(response)).single();
        return this.container.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosTriggerResponse> deleteInternal(Context context) {
        String spanName = "deleteTrigger." + this.container.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().deleteTrigger(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosTriggerResponse(response)).single();
        return this.container.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getDatabase().getClient().getServiceEndpoint());
    }
}

