/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.models.EncryptionKeyWrapMetadata;
import java.util.Arrays;

public final class ClientEncryptionKey
extends Resource {
    private String encryptionAlgorithm;
    private byte[] wrappedDataEncryptionKey;
    private EncryptionKeyWrapMetadata encryptionKeyWrapMetadata;

    public ClientEncryptionKey() {
    }

    public ClientEncryptionKey(String jsonString) {
        super(jsonString);
    }

    public String getEncryptionAlgorithm() {
        if (this.encryptionAlgorithm == null && super.has("encryptionAlgorithm")) {
            this.encryptionAlgorithm = super.getString("encryptionAlgorithm");
        }
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        BridgeInternal.setProperty(this, "encryptionAlgorithm", encryptionAlgorithm);
    }

    public byte[] getWrappedDataEncryptionKey() {
        if (this.wrappedDataEncryptionKey == null && super.has("wrappedDataEncryptionKey")) {
            this.wrappedDataEncryptionKey = super.getObject("wrappedDataEncryptionKey", byte[].class, new boolean[0]);
        }
        return this.wrappedDataEncryptionKey;
    }

    public void setWrappedDataEncryptionKey(byte[] wrappedDataEncryptionKey) {
        this.wrappedDataEncryptionKey = wrappedDataEncryptionKey;
        BridgeInternal.setProperty(this, "wrappedDataEncryptionKey", this.wrappedDataEncryptionKey);
    }

    public EncryptionKeyWrapMetadata getEncryptionKeyWrapMetadata() {
        if (this.encryptionKeyWrapMetadata == null && super.has("keyWrapMetadata")) {
            this.encryptionKeyWrapMetadata = super.getObject("keyWrapMetadata", EncryptionKeyWrapMetadata.class, new boolean[0]);
        }
        return this.encryptionKeyWrapMetadata;
    }

    public void setEncryptionKeyWrapMetadata(EncryptionKeyWrapMetadata encryptionKeyWrapMetadata) {
        this.encryptionKeyWrapMetadata = encryptionKeyWrapMetadata;
        BridgeInternal.setProperty(this, "keyWrapMetadata", this.encryptionKeyWrapMetadata);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !ClientEncryptionKey.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ClientEncryptionKey typedObj = (ClientEncryptionKey)obj;
        return typedObj.getResourceId().equals(this.getResourceId()) && Arrays.equals(typedObj.getWrappedDataEncryptionKey(), this.getWrappedDataEncryptionKey()) && typedObj.getEncryptionKeyWrapMetadata().equals(this.getEncryptionKeyWrapMetadata());
    }

    @Override
    public int hashCode() {
        return this.getResourceId().hashCode();
    }
}

