/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Exceptions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AsyncCacheNonBlocking<TKey, TValue> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncCacheNonBlocking.class);
    private final ConcurrentHashMap<TKey, AsyncLazyWithRefresh<TValue>> values = new ConcurrentHashMap();

    private Boolean removeNotFoundFromCacheException(CosmosException e) {
        if (Exceptions.isNotFound(e)) {
            return true;
        }
        return false;
    }

    public Mono<TValue> getAsync(TKey key, Function<TValue, Mono<TValue>> singleValueInitFunc, Function<TValue, Boolean> forceRefresh) {
        AsyncLazyWithRefresh<TValue> asyncLazyWithRefresh;
        AsyncLazyWithRefresh<TValue> preResult;
        AsyncLazyWithRefresh<TValue> initialLazyValue = this.values.get(key);
        if (initialLazyValue != null) {
            logger.debug("cache[{}] exists", key);
            return initialLazyValue.getValueAsync().flatMap(value -> {
                if (!((Boolean)forceRefresh.apply(value)).booleanValue()) {
                    return Mono.just((Object)value);
                }
                Mono refreshMono = initialLazyValue.createAndWaitForBackgroundRefreshTaskAsync(key, singleValueInitFunc);
                return refreshMono.onErrorResume(exception -> {
                    logger.debug("refresh cache [{}] resulted in error", key, exception);
                    if (initialLazyValue.shouldRemoveFromCache() && this.removeNotFoundFromCacheException((CosmosException)((Object)((Object)((Object)exception)))).booleanValue()) {
                        this.remove(key);
                    }
                    return Mono.error((Throwable)exception);
                });
            }).onErrorResume(exception -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("cache[{}] resulted in error", key, exception);
                }
                if (initialLazyValue.shouldRemoveFromCache()) {
                    this.remove(key);
                }
                return Mono.error((Throwable)exception);
            });
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cache[{}] doesn't exist, computing new value", key);
        }
        if ((preResult = this.values.putIfAbsent(key, asyncLazyWithRefresh = new AsyncLazyWithRefresh<TValue>(singleValueInitFunc))) == null) {
            preResult = asyncLazyWithRefresh;
        }
        AsyncLazyWithRefresh<TValue> result = preResult;
        return result.getValueAsync().onErrorResume(exception -> {
            if (logger.isDebugEnabled()) {
                logger.debug("cache[{}] resulted in error", key, exception);
            }
            if (result.shouldRemoveFromCache()) {
                this.remove(key);
            }
            return Mono.error((Throwable)exception);
        });
    }

    public void set(TKey key, TValue value) {
        if (logger.isDebugEnabled()) {
            logger.debug("set cache[{}]={}", key, value);
        }
        AsyncLazyWithRefresh<TValue> updatedValue = new AsyncLazyWithRefresh<TValue>(value);
        this.values.put(key, updatedValue);
    }

    public void remove(TKey key) {
        this.values.remove(key);
    }

    private class AsyncLazyWithRefresh<TValue> {
        private final AtomicBoolean removeFromCache = new AtomicBoolean(false);
        private final AtomicReference<Mono<TValue>> value;
        private Mono<TValue> refreshInProgress;
        private final AtomicBoolean refreshInProgressCompleted = new AtomicBoolean(false);

        public AsyncLazyWithRefresh(TValue value) {
            this.value = new AtomicReference();
            this.value.set(Mono.just(value));
            this.refreshInProgress = null;
        }

        public AsyncLazyWithRefresh(Function<TValue, Mono<TValue>> taskFactory) {
            this.value = new AtomicReference();
            this.value.set(taskFactory.apply(null).cache());
            this.refreshInProgress = null;
        }

        public Mono<TValue> getValueAsync() {
            return this.value.get();
        }

        public Mono<TValue> value() {
            return this.value.get();
        }

        public Mono<TValue> createAndWaitForBackgroundRefreshTaskAsync(TKey key, Function<TValue, Mono<TValue>> createRefreshFunction) {
            Mono<TValue> valueMono = this.value.get();
            return valueMono.flatMap(value -> {
                if (this.refreshInProgressCompleted.compareAndSet(false, true)) {
                    this.refreshInProgress = ((Mono)createRefreshFunction.apply(value)).cache();
                    return this.refreshInProgress.flatMap(response -> {
                        this.value.set(Mono.just((Object)response));
                        this.refreshInProgressCompleted.set(false);
                        return this.value.get();
                    }).doOnError(e -> this.refreshInProgressCompleted.set(false));
                }
                return this.refreshInProgress == null ? valueMono : this.refreshInProgress;
            });
        }

        public boolean shouldRemoveFromCache() {
            return this.removeFromCache.compareAndSet(false, true);
        }
    }
}

