/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConnectionEvent;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConnectionStateListenerMetrics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RntbdConnectionStateListener {
    private static final Logger logger = LoggerFactory.getLogger(RntbdConnectionStateListener.class);
    private final IAddressResolver addressResolver;
    private final RntbdEndpoint endpoint;
    private final RntbdConnectionStateListenerMetrics metrics;

    public RntbdConnectionStateListener(IAddressResolver addressResolver, RntbdEndpoint endpoint) {
        this.addressResolver = Preconditions.checkNotNull(addressResolver, "expected non-null addressResolver");
        this.endpoint = Preconditions.checkNotNull(endpoint, "expected non-null endpoint");
        this.metrics = new RntbdConnectionStateListenerMetrics();
    }

    public void onException(Throwable exception) {
        Preconditions.checkNotNull(exception, "expect non-null exception");
        this.metrics.record();
        if (exception instanceof IOException) {
            if (exception instanceof ClosedChannelException) {
                this.metrics.recordAddressUpdated(this.onConnectionEvent(RntbdConnectionEvent.READ_EOF, exception));
            } else if (logger.isDebugEnabled()) {
                logger.debug("Will not raise the connection state change event for error", exception);
            }
        }
    }

    public RntbdConnectionStateListenerMetrics getMetrics() {
        return this.metrics;
    }

    private int onConnectionEvent(RntbdConnectionEvent event, Throwable exception) {
        Preconditions.checkNotNull(exception, "expected non-null exception");
        if (event == RntbdConnectionEvent.READ_EOF) {
            if (!this.endpoint.isClosed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("onConnectionEvent({\"event\":{},\"time\":{},\"endpoint\":{},\"cause\":{})", new Object[]{event, RntbdObjectMapper.toJson(Instant.now()), RntbdObjectMapper.toJson(this.endpoint), RntbdObjectMapper.toJson(exception)});
                }
                return this.addressResolver.updateAddresses(this.endpoint.serverKey());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Endpoint closed while onConnectionEvent: {}", (Object)this.endpoint);
            }
        }
        return 0;
    }
}

