/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdResponse;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava27.Strings;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.CorruptedFrameException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdObjectMapper {
    private static final Logger logger = LoggerFactory.getLogger(RntbdObjectMapper.class);
    private static final SimpleFilterProvider filterProvider = new SimpleFilterProvider();
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new SimpleModule().addSerializer(Duration.class, (JsonSerializer)ToStringSerializer.instance).addDeserializer(Duration.class, (JsonDeserializer)DurationDeserializer.INSTANCE).addSerializer(Instant.class, (JsonSerializer)ToStringSerializer.instance)).setFilterProvider((FilterProvider)filterProvider);
    private static final ObjectWriter objectWriter = objectMapper.writer();
    private static final ConcurrentHashMap<Class<?>, String> simpleClassNames = new ConcurrentHashMap();

    private RntbdObjectMapper() {
    }

    public static <T> T readValue(File file, Class<T> type) throws IOException {
        Preconditions.checkNotNull(file, "expected non-null file");
        Preconditions.checkNotNull(type, "expected non-null type");
        return (T)objectMapper.readValue(file, type);
    }

    public static <T> T readValue(InputStream stream, Class<T> type) throws IOException {
        Preconditions.checkNotNull(stream, "expected non-null stream");
        Preconditions.checkNotNull(type, "expected non-null type");
        return (T)objectMapper.readValue(stream, type);
    }

    public static <T> T readValue(String string, Class<T> type) throws IOException {
        Preconditions.checkNotNull(string, "expected non-null string");
        Preconditions.checkNotNull(type, "expected non-null type");
        return (T)objectMapper.readValue(string, type);
    }

    public static String toJson(Object value) {
        try {
            return objectWriter.writeValueAsString(value);
        }
        catch (JsonProcessingException error) {
            logger.debug("could not convert {} value to JSON due to:", value.getClass(), (Object)error);
            try {
                return Strings.lenientFormat("{\"error\":%s}", objectWriter.writeValueAsString((Object)error.toString()));
            }
            catch (JsonProcessingException exception) {
                return "null";
            }
        }
    }

    public static String toString(Object value) {
        String name = simpleClassNames.computeIfAbsent(value.getClass(), Class::getSimpleName);
        return Strings.lenientFormat("%s(%s)", name, RntbdObjectMapper.toJson(value));
    }

    public static ObjectWriter writer() {
        return objectWriter;
    }

    static ObjectNode readTree(RntbdResponse response) {
        Preconditions.checkNotNull(response, "response");
        return RntbdObjectMapper.readTree(response.getContent());
    }

    static ObjectNode readTree(ByteBuf in) {
        JsonNode node;
        Preconditions.checkNotNull(in, "in");
        try (ByteBufInputStream istream = new ByteBufInputStream(in);){
            node = objectMapper.readTree((InputStream)istream);
        }
        catch (IOException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
        if (node.isObject()) {
            return (ObjectNode)node;
        }
        String cause = Strings.lenientFormat("Expected %s, not %s", JsonNodeType.OBJECT, node.getNodeType());
        throw new CorruptedFrameException(cause);
    }

    static void registerPropertyFilter(Class<?> type, Class<? extends PropertyFilter> filter) {
        Preconditions.checkNotNull(type, "type");
        Preconditions.checkNotNull(filter, "filter");
        try {
            filterProvider.addFilter(type.getSimpleName(), filter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException error) {
            throw new IllegalStateException(error);
        }
    }
}

