/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.aggregation;

import com.azure.cosmos.implementation.Undefined;
import com.azure.cosmos.implementation.query.ItemComparator;
import com.azure.cosmos.implementation.query.aggregation.Aggregator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;

public class MaxAggregator
implements Aggregator {
    private static final String MAX_PROPERTY_NAME = "max";
    private Object value = Undefined.value();

    static Object getValue(Object value) {
        if (value instanceof TextNode) {
            return ((JsonNode)value).asText();
        }
        if (value instanceof NumericNode) {
            return ((JsonNode)value).numberValue();
        }
        if (value instanceof BooleanNode) {
            return ((JsonNode)value).asBoolean();
        }
        if (value instanceof NullNode) {
            return null;
        }
        return value;
    }

    @Override
    public void aggregate(Object item) {
        ObjectNode objectNode;
        if (item instanceof ObjectNode && (objectNode = (ObjectNode)item).hasNonNull("count")) {
            long count = objectNode.get("count").asLong();
            if (count == 0L) {
                return;
            }
            item = objectNode.has(MAX_PROPERTY_NAME) ? MaxAggregator.getValue(objectNode.get(MAX_PROPERTY_NAME)) : Undefined.value();
        }
        if (item == Undefined.value()) {
            return;
        }
        if (Undefined.value().equals(this.value)) {
            this.value = item;
        } else if (ItemComparator.getInstance().compare(item, this.value) > 0) {
            this.value = item;
        }
    }

    @Override
    public Object getResult() {
        return this.value;
    }
}

