/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.metrics;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.query.metrics.QueryMetricsWriter;
import com.azure.cosmos.implementation.query.metrics.TextTable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class QueryMetricsTextWriter
extends QueryMetricsWriter {
    private final StringBuilder stringBuilder;
    private static final String ActivityIds = "Activity Ids";
    private static final String RETRIEVED_DOCUMENT_COUNT = "Retrieved Document Count";
    private static final String RETRIEVED_DOCUMENT_SIZE = "Retrieved Document Size";
    private static final String OUTPUT_DOCUMENT_COUNT = "Output Document Count";
    private static final String OUTPUT_DOCUMENT_SIZE = "Output Document Size";
    private static final String INDEX_UTILIZATION_TEXT = "Index Utilization";
    private static final String TOTAL_QUERY_EXECUTION_TIME = "Total Query Execution Time";
    private static final String QUERY_PREPARATION_TIMES = "Query Preparation Times";
    private static final String QUERY_COMPILATION_TIME = "Query Compilation Time";
    private static final String LOGICAL_PLAN_BUILD_TIME = "Logical Plan Build Time";
    private static final String PHYSICAL_PLAN_BUILD_TIME = "Physical Plan Build Time";
    private static final String QUERY_OPTIMIZATION_TIME = "Query Optimization Time";
    private static final String QUERY_ENGINE_TIMES = "Query Engine Times";
    private static final String INDEX_LOOKUP_TIME = "Index Lookup Time";
    private static final String DOCUMENT_LOAD_TIME = "Document Load Time";
    private static final String DOCUMENT_WRITE_TIME = "Document Write Time";
    private static final String RUNTIME_EXECUTION_TIMES = "Runtime Execution Times";
    private static final String TOTAL_EXECUTION_TIME = "Query Engine Execution Time";
    private static final String SYSTEM_FUNCTION_EXECUTION_TIME = "System Function Execution Time";
    private static final String USER_DEFINED_FUNCTION_EXECUTION_TIME = "User-defined Function Execution Time";
    private static final String CLIENT_SIDE_METRICS = "Client Side Metrics";
    private static final String RETRIES = "Retry Count";
    private static final String REQUEST_CHARGE = "Request Charge";
    private static final String FETCH_EXECUTION_RANGES = "Partition Execution Timeline";
    private static final String SCHEDULING_METRICS = "Scheduling Metrics";
    public static final String START_TIME_HEADER = "Start Time (UTC)";
    public static final String END_TIME_HEADER = "End Time (UTC)";
    public static final String DURATION_HEADER = "Duration (ms)";
    private static final String PARTITION_KEY_RANGE_HEADER = "Partition Key Range";
    private static final String NUMBER_OF_DOCUMENTS_HEADER = "NUMBER of Documents";
    private static final String RETRY_COUNT_HEADER = "Retry Count";
    private static final String ACTIVITY_ID_HEADER = "Activity Id";
    private static final String PARTITION_RANGE_HEADER = "Partition Range";
    private static final String RESPONSE_TIME_HEADER = "Response Time (ms)";
    private static final String RUN_TIME_HEADER = "Run Time (ms)";
    private static final String WAIT_TIME_HEADER = "Wait Time (ms)";
    private static final String TURNAROUND_TIME_HEADER = "Turnaround Time (ms)";
    private static final String NUMBER_OF_PREEMPTION_HEADER = "NUMBER of Preemptions";
    private static final String INDEX_UTILIZATION_INFO_METRICS = "Index Utilization Info Metrics";
    private static final String UTILIZED_SINGLE_INDEXES_METRICS = " Utilized Single Indexes Metrics";
    private static final String POTENTIAL_SINGLE_INDEXES_METRICS = "Potential Single Indexes Metrics";
    private static final String UTILIZED_COMPOSITE_INDEXES_METRICS = "Utilized Composite Indexes Metrics";
    private static final String POTENTIAL_COMPOSITE_INDEXES_METRICS = "Potential Composite Indexes Metrics";
    private static final String FILTER_EXPRESSION_HEADER = "Filter Expression";
    private static final String INDEX_DOCUMENT_EXPRESSION_HEADER = "Index Document Expression";
    private static final String FILTER_EXPRESSION_PRECISION_HEADER = "Filter Expression Precision";
    private static final String INDEX_PLAN_FULL_FIDELITY_HEADER = "Index Plan Full Fidelity";
    private static final String INDEX_IMPACT_SCORE_HEADER = "Index Impact Score";
    private static final String INDEX_DOCUMENT_EXPRESSIONS_HEADER = "Index Document Expressions";
    private static final int MAX_DATE_TIME_STRING_LENGTH = 16;
    private static final int START_TIME_HEADER_LENGTH = Math.max(16, "Start Time (UTC)".length());
    private static final int END_TIME_HEADER_LENGTH = Math.max(16, "End Time (UTC)".length());
    private static final int DURATION_HEADER_LENGTH = "Duration (ms)".length();
    private static final int PARTITION_KEY_RANGE_ID_HEADER_LENGTH = "Partition Key Range".length();
    private static final int NUMBER_OF_DOCUMENTS_HEADER_LENGTH = "NUMBER of Documents".length();
    private static final int RETRY_COUNT_HEADER_LENGTH = "Retry Count".length();
    private static final int ACTIVITY_ID_HEADER_LENGTH = UUID.randomUUID().toString().length();
    private static final TextTable.Column[] PARTITION_EXECUTION_TIMELINE_COLUMNS = new TextTable.Column[]{new TextTable.Column("Partition Key Range", PARTITION_KEY_RANGE_ID_HEADER_LENGTH), new TextTable.Column("Activity Id", ACTIVITY_ID_HEADER_LENGTH), new TextTable.Column("Start Time (UTC)", START_TIME_HEADER_LENGTH), new TextTable.Column("End Time (UTC)", END_TIME_HEADER_LENGTH), new TextTable.Column("Duration (ms)", DURATION_HEADER_LENGTH), new TextTable.Column("NUMBER of Documents", NUMBER_OF_DOCUMENTS_HEADER_LENGTH), new TextTable.Column("Retry Count", RETRY_COUNT_HEADER_LENGTH)};
    private static final TextTable PARTITION_EXECUTION_TIMELINE_TABLE = new TextTable(Arrays.asList(PARTITION_EXECUTION_TIMELINE_COLUMNS));
    private static final int PARTITION_ID_HEADER_LENGTH = "Partition Range".length();
    private static final int RESPONSE_TIME_HEADER_LENGTH = "Response Time (ms)".length();
    private static final int RUN_TIME_HEADER_LENGTH = "Run Time (ms)".length();
    private static final int WAIT_TIME_HEADER_LENGTH = "Wait Time (ms)".length();
    private static final int TURNAROUND_TIME_HEADER_LENGTH = "Turnaround Time (ms)".length();
    private static final int NUMBER_OF_PREEMPTION_HEADER_LENGTH = "NUMBER of Preemptions".length();
    private static final TextTable.Column[] SCHEDULING_METRICS_COLUMNS = new TextTable.Column[]{new TextTable.Column("Partition Range", PARTITION_ID_HEADER_LENGTH), new TextTable.Column("Response Time (ms)", RESPONSE_TIME_HEADER_LENGTH), new TextTable.Column("Run Time (ms)", RUN_TIME_HEADER_LENGTH), new TextTable.Column("Wait Time (ms)", WAIT_TIME_HEADER_LENGTH), new TextTable.Column("Turnaround Time (ms)", TURNAROUND_TIME_HEADER_LENGTH), new TextTable.Column("NUMBER of Preemptions", NUMBER_OF_PREEMPTION_HEADER_LENGTH)};
    private static final TextTable SCHEDULING_METRICS_TABLE = new TextTable(Arrays.asList(SCHEDULING_METRICS_COLUMNS));
    private static final int FILTER_EXPRESSION_HEADER_LENGTH = "Filter Expression".length();
    private static final int INDEX_DOCUMENT_EXPRESSION_HEADER_LENGTH = "Index Document Expression".length();
    private static final int FILTER_EXPRESSION_PRECISION_HEADER_LENGTH = "Filter Expression Precision".length();
    private static final int INDEX_PLAN_FULL_FIDELITY_HEADER_LENGTH = "Index Plan Full Fidelity".length();
    private static final int INDEX_IMPACT_SCORE_HEADER_LENGTH = "Index Impact Score".length();
    private static final TextTable.Column[] UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_COLUMNS = new TextTable.Column[]{new TextTable.Column("Filter Expression", FILTER_EXPRESSION_HEADER_LENGTH), new TextTable.Column("Index Document Expression", INDEX_DOCUMENT_EXPRESSION_HEADER_LENGTH), new TextTable.Column("Filter Expression Precision", FILTER_EXPRESSION_PRECISION_HEADER_LENGTH), new TextTable.Column("Index Plan Full Fidelity", INDEX_PLAN_FULL_FIDELITY_HEADER_LENGTH), new TextTable.Column("Index Impact Score", INDEX_IMPACT_SCORE_HEADER_LENGTH)};
    private static final TextTable UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE = new TextTable(Arrays.asList(UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_COLUMNS));
    private static final int INDEX_DOCUMENT_EXPRESSIONS_HEADER_LENGTH = "Index Document Expressions".length();
    private static final TextTable.Column[] UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_COLUMNS = new TextTable.Column[]{new TextTable.Column("Index Document Expressions", INDEX_DOCUMENT_EXPRESSIONS_HEADER_LENGTH), new TextTable.Column("Index Plan Full Fidelity", INDEX_PLAN_FULL_FIDELITY_HEADER_LENGTH), new TextTable.Column("Index Impact Score", INDEX_IMPACT_SCORE_HEADER_LENGTH)};
    private static final TextTable UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE = new TextTable(Arrays.asList(UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_COLUMNS));
    private String lastFetchPartitionId;
    private String lastActivityId;
    private Instant lastStartTime;
    private Instant lastEndTime;
    private long lastFetchDocumentCount;
    private long lastFetchRetryCount;
    private String lastSchedulingPartitionId;
    private long lastResponseTime;
    private long lastRunTime;
    private long lastWaitTime;
    private long lastTurnaroundTime;
    private long lastNumberOfPreemptions;
    private String lastUtilizedSingleFilterExpression;
    private String lastUtilizedSingleIndexDocumentExpression;
    private boolean lastUtilizedSingleFilterExpressionPrecision;
    private boolean lastUtilizedSingleIndexPlanFullFidelity;
    private String lastUtilizedSingleIndexImpactScore;
    private String lastPotentialSingleFilterExpression;
    private String lastPotentialSingleIndexDocumentExpression;
    private boolean lastPotentialSingleFilterExpressionPrecision;
    private boolean lastPotentialSingleIndexPlanFullFidelity;
    private String lastPotentialSingleIndexImpactScore;
    private List<String> lastUtilizedCompositeIndexDocumentExpressions;
    private boolean lastUtilizedCompositeIndexPlanFullFidelity;
    private String lastUtilizedCompositeIndexImpactScore;
    private List<String> lastPotentialCompositeIndexDocumentExpressions;
    private boolean lastPotentialCompositeIndexPlanFullFidelity;
    private String lastPotentialCompositeIndexImpactScore;
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss:SSSS").withZone(ZoneOffset.UTC);
    private static final int NANOS_TO_MILLIS = 1000000;

    public QueryMetricsTextWriter(StringBuilder stringBuilder) {
        assert (stringBuilder != null);
        this.stringBuilder = stringBuilder;
    }

    @Override
    protected void writeBeforeQueryMetrics() {
    }

    @Override
    protected void writeRetrievedDocumentCount(long retrievedDocumentCount) {
        QueryMetricsTextWriter.appendCountToStringBuilder(this.stringBuilder, RETRIEVED_DOCUMENT_COUNT, retrievedDocumentCount, 0);
    }

    @Override
    protected void writeRetrievedDocumentSize(long retrievedDocumentSize) {
        QueryMetricsTextWriter.appendBytesToStringBuilder(this.stringBuilder, RETRIEVED_DOCUMENT_SIZE, retrievedDocumentSize, 0);
    }

    @Override
    protected void writeOutputDocumentCount(long outputDocumentCount) {
        QueryMetricsTextWriter.appendCountToStringBuilder(this.stringBuilder, OUTPUT_DOCUMENT_COUNT, outputDocumentCount, 0);
    }

    @Override
    protected void writeOutputDocumentSize(long outputDocumentSize) {
        QueryMetricsTextWriter.appendBytesToStringBuilder(this.stringBuilder, OUTPUT_DOCUMENT_SIZE, outputDocumentSize, 0);
    }

    @Override
    protected void writeIndexHitRatio(double indexHitRatio) {
        QueryMetricsTextWriter.appendPercentageToStringBuilder(this.stringBuilder, INDEX_UTILIZATION_TEXT, indexHitRatio, 0);
    }

    @Override
    protected void writeTotalQueryExecutionTime(Duration totalQueryExecutionTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, TOTAL_QUERY_EXECUTION_TIME, QueryMetricsTextWriter.durationToMilliseconds(totalQueryExecutionTime), 0);
    }

    @Override
    protected void writeBeforeQueryPreparationTimes() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, QUERY_PREPARATION_TIMES, 1);
    }

    @Override
    protected void writeQueryCompilationTime(Duration queryCompilationTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, QUERY_COMPILATION_TIME, QueryMetricsTextWriter.durationToMilliseconds(queryCompilationTime), 2);
    }

    @Override
    protected void writeLogicalPlanBuildTime(Duration logicalPlanBuildTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, LOGICAL_PLAN_BUILD_TIME, QueryMetricsTextWriter.durationToMilliseconds(logicalPlanBuildTime), 2);
    }

    @Override
    protected void writePhysicalPlanBuildTime(Duration physicalPlanBuildTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, PHYSICAL_PLAN_BUILD_TIME, QueryMetricsTextWriter.durationToMilliseconds(physicalPlanBuildTime), 2);
    }

    @Override
    protected void writeQueryOptimizationTime(Duration queryOptimizationTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, QUERY_OPTIMIZATION_TIME, QueryMetricsTextWriter.durationToMilliseconds(queryOptimizationTime), 2);
    }

    @Override
    protected void writeAfterQueryPreparationTimes() {
    }

    @Override
    protected void writeIndexLookupTime(Duration indexLookupTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, INDEX_LOOKUP_TIME, QueryMetricsTextWriter.durationToMilliseconds(indexLookupTime), 1);
    }

    @Override
    protected void writeDocumentLoadTime(Duration documentLoadTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, DOCUMENT_LOAD_TIME, QueryMetricsTextWriter.durationToMilliseconds(documentLoadTime), 1);
    }

    @Override
    protected void writeVMExecutionTime(Duration vMExecutionTime) {
    }

    @Override
    protected void writeBeforeRuntimeExecutionTimes() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, RUNTIME_EXECUTION_TIMES, 1);
    }

    @Override
    protected void writeQueryEngineExecutionTime(Duration queryEngineExecutionTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, QUERY_ENGINE_TIMES, QueryMetricsTextWriter.durationToMilliseconds(queryEngineExecutionTime), 2);
    }

    @Override
    protected void writeSystemFunctionExecutionTime(Duration systemFunctionExecutionTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, SYSTEM_FUNCTION_EXECUTION_TIME, QueryMetricsTextWriter.durationToMilliseconds(systemFunctionExecutionTime), 2);
    }

    @Override
    protected void writeUserDefinedFunctionExecutionTime(Duration userDefinedFunctionExecutionTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, USER_DEFINED_FUNCTION_EXECUTION_TIME, QueryMetricsTextWriter.durationToMilliseconds(userDefinedFunctionExecutionTime), 2);
    }

    @Override
    protected void writeAfterRuntimeExecutionTimes() {
    }

    @Override
    protected void writeDocumentWriteTime(Duration documentWriteTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, DOCUMENT_WRITE_TIME, QueryMetricsTextWriter.durationToMilliseconds(documentWriteTime), 1);
    }

    @Override
    protected void writeBeforeClientSideMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, CLIENT_SIDE_METRICS, 0);
    }

    @Override
    protected void writeRetries(long retries) {
        QueryMetricsTextWriter.appendCountToStringBuilder(this.stringBuilder, "Retry Count", retries, 1);
    }

    @Override
    protected void writeRequestCharge(double requestCharge) {
        QueryMetricsTextWriter.appendRUToStringBuilder(this.stringBuilder, REQUEST_CHARGE, requestCharge, 1);
    }

    @Override
    protected void writeBeforePartitionExecutionTimeline() {
        QueryMetricsTextWriter.appendNewlineToStringBuilder(this.stringBuilder);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, FETCH_EXECUTION_RANGES, 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PARTITION_EXECUTION_TIMELINE_TABLE.getTopLine(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PARTITION_EXECUTION_TIMELINE_TABLE.getHeader(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PARTITION_EXECUTION_TIMELINE_TABLE.getMiddleLine(), 1);
    }

    @Override
    protected void writeBeforeFetchExecutionRange() {
    }

    @Override
    protected void writeFetchPartitionKeyRangeId(String partitionId) {
        this.lastFetchPartitionId = partitionId;
    }

    @Override
    protected void writeActivityId(String activityId) {
        this.lastActivityId = activityId;
    }

    @Override
    protected void writeStartTime(Instant startTime) {
        this.lastStartTime = startTime;
    }

    @Override
    protected void writeEndTime(Instant endTime) {
        this.lastEndTime = endTime;
    }

    @Override
    protected void writeFetchDocumentCount(long numberOfDocuments) {
        this.lastFetchDocumentCount = numberOfDocuments;
    }

    @Override
    protected void writeFetchRetryCount(long retryCount) {
        this.lastFetchRetryCount = retryCount;
    }

    @Override
    protected void writeAfterFetchExecutionRange() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PARTITION_EXECUTION_TIMELINE_TABLE.getRow(Arrays.asList(this.lastFetchPartitionId, this.lastActivityId, DATE_TIME_FORMATTER.format(this.lastStartTime), DATE_TIME_FORMATTER.format(this.lastEndTime), QueryMetricsTextWriter.nanosToMilliSeconds(this.lastEndTime.minusNanos(this.lastStartTime.getNano()).getNano()), this.lastFetchDocumentCount, this.lastFetchRetryCount)), 1);
    }

    @Override
    protected void writeAfterPartitionExecutionTimeline() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PARTITION_EXECUTION_TIMELINE_TABLE.getBottomLine(), 1);
    }

    @Override
    protected void writeBeforeSchedulingMetrics() {
        QueryMetricsTextWriter.appendNewlineToStringBuilder(this.stringBuilder);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SCHEDULING_METRICS, 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SCHEDULING_METRICS_TABLE.getTopLine(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SCHEDULING_METRICS_TABLE.getHeader(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SCHEDULING_METRICS_TABLE.getMiddleLine(), 1);
    }

    @Override
    protected void writeBeforePartitionSchedulingDuration() {
    }

    @Override
    protected void writePartitionSchedulingDurationId(String partitionId) {
        this.lastSchedulingPartitionId = partitionId;
    }

    @Override
    protected void writeResponseTime(long responseTime) {
        this.lastResponseTime = responseTime;
    }

    @Override
    protected void writeRunTime(long runTime) {
        this.lastRunTime = runTime;
    }

    @Override
    protected void writeWaitTime(long waitTime) {
        this.lastWaitTime = waitTime;
    }

    @Override
    protected void writeTurnaroundTime(long turnaroundTime) {
        this.lastTurnaroundTime = turnaroundTime;
    }

    @Override
    protected void writeNumberOfPreemptions(long numPreemptions) {
        this.lastNumberOfPreemptions = numPreemptions;
    }

    @Override
    protected void writeAfterPartitionSchedulingDuration() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SCHEDULING_METRICS_TABLE.getRow(Arrays.asList(this.lastSchedulingPartitionId, this.lastResponseTime, this.lastRunTime, this.lastWaitTime, this.lastTurnaroundTime, this.lastNumberOfPreemptions)), 1);
    }

    @Override
    protected void writeAfterSchedulingMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SCHEDULING_METRICS_TABLE.getBottomLine(), 1);
    }

    @Override
    protected void writeAfterClientSideMetrics() {
    }

    @Override
    protected void writeBeforeIndexUtilizationInfoMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, INDEX_UTILIZATION_INFO_METRICS, 0);
    }

    @Override
    protected void writeBeforeUtilizedSingleIndexesMetrics() {
        QueryMetricsTextWriter.appendNewlineToStringBuilder(this.stringBuilder);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_SINGLE_INDEXES_METRICS, 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getTopLine(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getHeader(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getMiddleLine(), 1);
    }

    @Override
    protected void writeBeforeUtilizedSingleIndex() {
    }

    @Override
    protected void writeUtilizedSingleFilterExpression(String filterExpression) {
        this.lastUtilizedSingleFilterExpression = filterExpression;
    }

    @Override
    protected void writeUtilizedSingleIndexDocumentExpression(String indexDocumentExpression) {
        this.lastUtilizedSingleIndexDocumentExpression = indexDocumentExpression;
    }

    @Override
    protected void writeUtilizedSingleFilterExpressionPrecision(boolean filterExpressionPrecision) {
        this.lastUtilizedSingleFilterExpressionPrecision = filterExpressionPrecision;
    }

    @Override
    protected void writeUtilizedSingleIndexPlanFullFidelity(boolean indexPlanFullFidelity) {
        this.lastUtilizedSingleIndexPlanFullFidelity = indexPlanFullFidelity;
    }

    @Override
    protected void writeUtilizedSingleIndexImpactScore(String indexImpactScore) {
        this.lastUtilizedSingleIndexImpactScore = indexImpactScore;
    }

    @Override
    protected void writeAfterUtilizedSingleIndex() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getRow(Arrays.asList(this.lastUtilizedSingleFilterExpression, this.lastUtilizedSingleIndexDocumentExpression, this.lastUtilizedSingleFilterExpressionPrecision, this.lastUtilizedSingleIndexPlanFullFidelity, this.lastUtilizedSingleIndexImpactScore)), 1);
    }

    @Override
    protected void writeAfterUtilizedSingleIndexesMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getBottomLine(), 1);
    }

    @Override
    protected void writeBeforePotentialSingleIndexesMetrics() {
        QueryMetricsTextWriter.appendNewlineToStringBuilder(this.stringBuilder);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, POTENTIAL_SINGLE_INDEXES_METRICS, 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getTopLine(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getHeader(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getMiddleLine(), 1);
    }

    @Override
    protected void writeBeforePotentialSingleIndex() {
    }

    @Override
    protected void writePotentialSingleFilterExpression(String filterExpression) {
        this.lastPotentialSingleFilterExpression = filterExpression;
    }

    @Override
    protected void writePotentialSingleIndexDocumentExpression(String indexDocumentExpression) {
        this.lastPotentialSingleIndexDocumentExpression = indexDocumentExpression;
    }

    @Override
    protected void writePotentialSingleFilterExpressionPrecision(boolean filterExpressionPrecision) {
        this.lastPotentialSingleFilterExpressionPrecision = filterExpressionPrecision;
    }

    @Override
    protected void writePotentialSingleIndexPlanFullFidelity(boolean indexPlanFullFidelity) {
        this.lastPotentialSingleIndexPlanFullFidelity = indexPlanFullFidelity;
    }

    @Override
    protected void writePotentialSingleIndexImpactScore(String indexImpactScore) {
        this.lastPotentialSingleIndexImpactScore = indexImpactScore;
    }

    @Override
    protected void writeAfterPotentialSingleIndex() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getRow(Arrays.asList(this.lastPotentialSingleFilterExpression, this.lastPotentialSingleIndexDocumentExpression, this.lastPotentialSingleFilterExpressionPrecision, this.lastPotentialSingleIndexPlanFullFidelity, this.lastPotentialSingleIndexImpactScore)), 1);
    }

    @Override
    protected void writeAfterPotentialSingleIndexesMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_SINGLE_INDEXES_TABLE.getBottomLine(), 1);
    }

    @Override
    protected void writeBeforeUtilizedCompositeIndexesMetrics() {
        QueryMetricsTextWriter.appendNewlineToStringBuilder(this.stringBuilder);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_COMPOSITE_INDEXES_METRICS, 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getTopLine(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getHeader(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getMiddleLine(), 1);
    }

    @Override
    protected void writeBeforeUtilizedCompositeIndex() {
    }

    @Override
    protected void writeUtilizedCompositeIndexDocumentExpressions(List<String> indexDocumentExpressions) {
        this.lastUtilizedCompositeIndexDocumentExpressions = indexDocumentExpressions;
    }

    @Override
    protected void writeUtilizedCompositeIndexPlanFullFidelity(boolean indexPlanFullFidelity) {
        this.lastUtilizedCompositeIndexPlanFullFidelity = indexPlanFullFidelity;
    }

    @Override
    protected void writeUtilizedCompositeIndexImpactScore(String indexImpactScore) {
        this.lastUtilizedCompositeIndexImpactScore = indexImpactScore;
    }

    @Override
    protected void writeAfterUtilizedCompositeIndex() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getRow(Arrays.asList(this.lastUtilizedCompositeIndexDocumentExpressions, this.lastUtilizedCompositeIndexPlanFullFidelity, this.lastUtilizedCompositeIndexImpactScore)), 1);
    }

    @Override
    protected void writeAfterUtilizedCompositeIndexesMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getBottomLine(), 1);
    }

    @Override
    protected void writeBeforePotentialCompositeIndexesMetrics() {
        QueryMetricsTextWriter.appendNewlineToStringBuilder(this.stringBuilder);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, POTENTIAL_COMPOSITE_INDEXES_METRICS, 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getTopLine(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getHeader(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getMiddleLine(), 1);
    }

    @Override
    protected void writeBeforePotentialCompositeIndex() {
    }

    @Override
    protected void writePotentialCompositeIndexDocumentExpressions(List<String> indexDocumentExpressions) {
        this.lastPotentialCompositeIndexDocumentExpressions = indexDocumentExpressions;
    }

    @Override
    protected void writePotentialCompositeIndexPlanFullFidelity(boolean indexPlanFullFidelity) {
        this.lastPotentialCompositeIndexPlanFullFidelity = indexPlanFullFidelity;
    }

    @Override
    protected void writePotentialCompositeIndexImpactScore(String indexImpactScore) {
        this.lastPotentialCompositeIndexImpactScore = indexImpactScore;
    }

    @Override
    protected void writeAfterPotentialCompositeIndex() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getRow(Arrays.asList(this.lastPotentialCompositeIndexDocumentExpressions, this.lastPotentialCompositeIndexPlanFullFidelity, this.lastPotentialCompositeIndexImpactScore)), 1);
    }

    @Override
    protected void writeAfterPotentialCompositeIndexesMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, UTILIZED_OR_POTENTIAL_COMPOSITE_INDEXES_TABLE.getBottomLine(), 1);
    }

    @Override
    protected void writeAfterIndexUtilizationInfoMetrics() {
    }

    @Override
    protected void writeAfterQueryMetrics() {
    }

    static HashMap<String, Double> parseDelimitedString(String delimitedString) {
        String[] headerAttributes;
        if (delimitedString == null) {
            throw new NullPointerException("delimitedString");
        }
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        boolean key = false;
        boolean value = true;
        for (String attribute : headerAttributes = StringUtils.split(delimitedString, ";")) {
            String[] attributeKeyValue = StringUtils.split(attribute, "=");
            if (attributeKeyValue.length != 2) {
                throw new NullPointerException("recieved a malformed delimited STRING");
            }
            String attributeKey = attributeKeyValue[0];
            double attributeValue = Double.parseDouble(attributeKeyValue[1]);
            metrics.put(attributeKey, attributeValue);
        }
        return metrics;
    }

    static Duration durationFromMetrics(HashMap<String, Double> metrics, String key) {
        Double durationInMilliseconds = metrics.get(key);
        if (durationInMilliseconds == null) {
            return Duration.ZERO;
        }
        long seconds = (long)(durationInMilliseconds / 1000.0);
        long nanoseconds = (long)((durationInMilliseconds - (double)seconds * 1000.0) * 1000000.0);
        return Duration.ofSeconds(seconds, nanoseconds);
    }

    static double durationToMilliseconds(Duration duration) {
        double seconds = duration.getSeconds();
        double nano = duration.getNano();
        return seconds * 1000.0 + nano / 1000000.0;
    }

    static Duration getDurationFromMetrics(HashMap<String, Double> metrics, String key) {
        double timeSpanInMilliseconds = metrics.get(key);
        Duration timeSpanFromMetrics = QueryMetricsTextWriter.doubleMillisecondsToDuration(timeSpanInMilliseconds);
        return timeSpanFromMetrics;
    }

    private static Duration doubleMillisecondsToDuration(double timeSpanInMilliseconds) {
        long timeInNanoSeconds = (long)(timeSpanInMilliseconds * 1000000.0);
        return Duration.ofNanos(timeInNanoSeconds);
    }

    private static void appendToStringBuilder(StringBuilder stringBuilder, String property, String value, String units, int indentLevel) {
        String Indent = "  ";
        String FormatString = "%-40s : %15s %-12s %s";
        stringBuilder.append(String.format(Locale.ROOT, "%-40s : %15s %-12s %s", StringUtils.repeat("  ", indentLevel) + property, value, units, System.lineSeparator()));
    }

    static void appendBytesToStringBuilder(StringBuilder stringBuilder, String property, long bytes, int indentLevel) {
        String BytesFormatString = "%d";
        String BytesUnitString = "bytes";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%d", bytes), "bytes", indentLevel);
    }

    static void appendMillisecondsToStringBuilder(StringBuilder stringBuilder, String property, double milliseconds, int indentLevel) {
        String MillisecondsFormatString = "%f";
        String MillisecondsUnitString = "milliseconds";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%f", milliseconds), "milliseconds", indentLevel);
    }

    static void appendNanosecondsToStringBuilder(StringBuilder stringBuilder, String property, double nanoSeconds, int indentLevel) {
        String MillisecondsFormatString = "%.2f";
        String MillisecondsUnitString = "milliseconds";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%.2f", QueryMetricsTextWriter.nanosToMilliSeconds(nanoSeconds)), "milliseconds", indentLevel);
    }

    static double nanosToMilliSeconds(double nanos) {
        return nanos / 1000000.0;
    }

    static void appendHeaderToStringBuilder(StringBuilder stringBuilder, String headerTitle, int indentLevel) {
        String Indent = "  ";
        String FormatString = "%s %s";
        stringBuilder.append(String.format(Locale.ROOT, "%s %s", String.join((CharSequence)StringUtils.repeat("  ", indentLevel), new CharSequence[0]) + headerTitle, System.lineSeparator()));
    }

    static void appendRUToStringBuilder(StringBuilder stringBuilder, String property, double requestCharge, int indentLevel) {
        String RequestChargeFormatString = "%s";
        String RequestChargeUnitString = "RUs";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format(Locale.ROOT, "%s", requestCharge), "RUs", indentLevel);
    }

    static void appendActivityIdsToStringBuilder(StringBuilder stringBuilder, String activityIdsLabel, List<String> activityIds, int indentLevel) {
        String Indent = "  ";
        stringBuilder.append(activityIdsLabel);
        stringBuilder.append(System.lineSeparator());
        for (String activityId : activityIds) {
            stringBuilder.append("  ");
            stringBuilder.append(activityId);
            stringBuilder.append(System.lineSeparator());
        }
    }

    static void appendPercentageToStringBuilder(StringBuilder stringBuilder, String property, double percentage, int indentLevel) {
        String PercentageFormatString = "%.2f";
        String PercentageUnitString = "%";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%.2f", percentage * 100.0), "%", indentLevel);
    }

    static void appendCountToStringBuilder(StringBuilder stringBuilder, String property, long count, int indentLevel) {
        String CountFormatString = "%s";
        String CountUnitString = "";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%s", count), "", indentLevel);
    }

    static void appendNewlineToStringBuilder(StringBuilder stringBuilder) {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(stringBuilder, "", 0);
    }
}

