/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.util.Beta;
import java.time.Duration;
import java.time.Instant;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class ChangeFeedProcessorOptions {
    public static final Duration DEFAULT_RENEW_INTERVAL = Duration.ofMillis(0L).plusSeconds(17L);
    public static final Duration DEFAULT_ACQUIRE_INTERVAL = Duration.ofMillis(0L).plusSeconds(13L);
    public static final Duration DEFAULT_EXPIRATION_INTERVAL = Duration.ofMillis(0L).plusSeconds(60L);
    public static final Duration DEFAULT_FEED_POLL_DELAY = Duration.ofMillis(0L).plusSeconds(5L);
    private Duration leaseRenewInterval = DEFAULT_RENEW_INTERVAL;
    private Duration leaseAcquireInterval = DEFAULT_ACQUIRE_INTERVAL;
    private Duration leaseExpirationInterval = DEFAULT_EXPIRATION_INTERVAL;
    private Duration feedPollDelay = DEFAULT_FEED_POLL_DELAY;
    private String leasePrefix;
    private int maxItemCount = 100;
    private String startContinuation;
    private Instant startTime;
    private boolean startFromBeginning = false;
    private int minScaleCount;
    private int maxScaleCount = 0;
    private Scheduler scheduler = Schedulers.boundedElastic();

    public Duration getLeaseRenewInterval() {
        return this.leaseRenewInterval;
    }

    public ChangeFeedProcessorOptions setLeaseRenewInterval(Duration leaseRenewInterval) {
        this.leaseRenewInterval = leaseRenewInterval;
        return this;
    }

    public Duration getLeaseAcquireInterval() {
        return this.leaseAcquireInterval;
    }

    public ChangeFeedProcessorOptions setLeaseAcquireInterval(Duration leaseAcquireInterval) {
        this.leaseAcquireInterval = leaseAcquireInterval;
        return this;
    }

    public Duration getLeaseExpirationInterval() {
        return this.leaseExpirationInterval;
    }

    public ChangeFeedProcessorOptions setLeaseExpirationInterval(Duration leaseExpirationInterval) {
        this.leaseExpirationInterval = leaseExpirationInterval;
        return this;
    }

    public Duration getFeedPollDelay() {
        return this.feedPollDelay;
    }

    public ChangeFeedProcessorOptions setFeedPollDelay(Duration feedPollDelay) {
        this.feedPollDelay = feedPollDelay;
        return this;
    }

    public String getLeasePrefix() {
        return this.leasePrefix;
    }

    public ChangeFeedProcessorOptions setLeasePrefix(String leasePrefix) {
        this.leasePrefix = leasePrefix;
        return this;
    }

    public int getMaxItemCount() {
        return this.maxItemCount;
    }

    public ChangeFeedProcessorOptions setMaxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public String getStartContinuation() {
        return this.startContinuation;
    }

    public ChangeFeedProcessorOptions setStartContinuation(String startContinuation) {
        this.startContinuation = startContinuation;
        return this;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public ChangeFeedProcessorOptions setStartTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public boolean isStartFromBeginning() {
        return this.startFromBeginning;
    }

    public ChangeFeedProcessorOptions setStartFromBeginning(boolean startFromBeginning) {
        this.startFromBeginning = startFromBeginning;
        return this;
    }

    public int getMinScaleCount() {
        return this.minScaleCount;
    }

    public ChangeFeedProcessorOptions setMinScaleCount(int minScaleCount) {
        this.minScaleCount = minScaleCount;
        return this;
    }

    public int getMaxScaleCount() {
        return this.maxScaleCount;
    }

    public ChangeFeedProcessorOptions setMaxScaleCount(int maxScaleCount) {
        this.maxScaleCount = maxScaleCount;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_26_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Beta(value=Beta.SinceVersion.V4_26_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ChangeFeedProcessorOptions setScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            throw new IllegalArgumentException("scheduler");
        }
        this.scheduler = scheduler;
        return this;
    }
}

