/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ClientEncryptionKey;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.models.EncryptionKeyWrapMetadata;
import com.azure.cosmos.util.Beta;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

@Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class CosmosClientEncryptionKeyProperties {
    private ClientEncryptionKey clientEncryptionKey;

    CosmosClientEncryptionKeyProperties(String jsonString) {
        this.clientEncryptionKey = new ClientEncryptionKey(jsonString);
    }

    CosmosClientEncryptionKeyProperties(ClientEncryptionKey clientEncryptionKey) {
        this.clientEncryptionKey = clientEncryptionKey;
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosClientEncryptionKeyProperties(String id, String encryptionAlgorithm, byte[] wrappedDataEncryptionKey, EncryptionKeyWrapMetadata encryptionKeyWrapMetadata) {
        this.clientEncryptionKey = new ClientEncryptionKey();
        this.clientEncryptionKey.setId(id);
        this.clientEncryptionKey.setEncryptionAlgorithm(encryptionAlgorithm);
        this.clientEncryptionKey.setWrappedDataEncryptionKey(wrappedDataEncryptionKey);
        this.clientEncryptionKey.setEncryptionKeyWrapMetadata(encryptionKeyWrapMetadata);
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getEncryptionAlgorithm() {
        return this.clientEncryptionKey.getEncryptionAlgorithm();
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosClientEncryptionKeyProperties setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.clientEncryptionKey.setEncryptionAlgorithm(encryptionAlgorithm);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public byte[] getWrappedDataEncryptionKey() {
        return this.clientEncryptionKey.getWrappedDataEncryptionKey();
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosClientEncryptionKeyProperties setWrappedDataEncryptionKey(byte[] wrappedDataEncryptionKey) {
        this.clientEncryptionKey.setWrappedDataEncryptionKey(wrappedDataEncryptionKey);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public EncryptionKeyWrapMetadata getEncryptionKeyWrapMetadata() {
        return this.clientEncryptionKey.getEncryptionKeyWrapMetadata();
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosClientEncryptionKeyProperties setEncryptionKeyWrapMetadata(EncryptionKeyWrapMetadata encryptionKeyWrapMetadata) {
        this.clientEncryptionKey.setEncryptionKeyWrapMetadata(encryptionKeyWrapMetadata);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getId() {
        return this.clientEncryptionKey.getId();
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosClientEncryptionKeyProperties setId(String id) {
        this.clientEncryptionKey.setId(id);
        return this;
    }

    String getResourceId() {
        return this.clientEncryptionKey.getResourceId();
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Instant getTimestamp() {
        return this.clientEncryptionKey.getTimestamp();
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getETag() {
        return this.clientEncryptionKey.getETag();
    }

    Resource getResource() {
        return this.clientEncryptionKey;
    }

    ClientEncryptionKey getClientEncryptionKey() {
        return new ClientEncryptionKey(this.clientEncryptionKey.toJson());
    }

    static List<CosmosClientEncryptionKeyProperties> getClientEncryptionKeys(List<ClientEncryptionKey> results) {
        return results.stream().map(CosmosClientEncryptionKeyProperties::new).collect(Collectors.toList());
    }
}

