/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.AvailabilityStrategy;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import java.time.Duration;

public class CosmosEndToEndOperationLatencyPolicyConfigBuilder {
    private boolean isEnabled = true;
    private final Duration endToEndOperationTimeout;
    private AvailabilityStrategy availabilityStrategy;

    public CosmosEndToEndOperationLatencyPolicyConfigBuilder(Duration endToEndOperationTimeout) {
        this.endToEndOperationTimeout = endToEndOperationTimeout;
    }

    public CosmosEndToEndOperationLatencyPolicyConfig build() {
        if (this.endToEndOperationTimeout == null && this.isEnabled) {
            throw new IllegalArgumentException("endToEndOperationTimeout must be set if the policy is enabled");
        }
        return new CosmosEndToEndOperationLatencyPolicyConfig(this.isEnabled, this.endToEndOperationTimeout, this.availabilityStrategy);
    }

    public CosmosEndToEndOperationLatencyPolicyConfigBuilder enable(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public CosmosEndToEndOperationLatencyPolicyConfigBuilder availabilityStrategy(AvailabilityStrategy availabilityStrategy) {
        this.availabilityStrategy = availabilityStrategy;
        return this;
    }
}

