/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.ReplicatedResourceClientUtils;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import java.util.Map;

public class SessionContainerUtil {
    public static boolean shouldUpdateSessionToken(RxDocumentServiceRequest request, Map<String, String> responseHeaders, Utils.ValueHolder<ResourceId> resourceId, Utils.ValueHolder<String> collectionName) {
        String resourceIdString;
        resourceId.v = null;
        String ownerFullName = responseHeaders.get("x-ms-alt-content-path");
        if (Strings.isNullOrEmpty(ownerFullName)) {
            ownerFullName = request.getResourceAddress();
        }
        collectionName.v = PathsHelper.getCollectionPath(ownerFullName);
        if (!request.getIsNameBased()) {
            resourceIdString = request.getResourceId();
        } else {
            resourceIdString = responseHeaders.get("x-ms-content-path");
            if (Strings.isNullOrEmpty(resourceIdString)) {
                resourceIdString = request.getResourceId();
            }
        }
        if (!Strings.isNullOrEmpty(resourceIdString)) {
            resourceId.v = ResourceId.parse(resourceIdString);
            if (((ResourceId)resourceId.v).getDocumentCollection() != 0 && !ReplicatedResourceClientUtils.isReadingFromMaster(request.getResourceType(), request.getOperationType())) {
                return true;
            }
        }
        return false;
    }
}

