/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.models.CosmosItemOperation;
import java.util.concurrent.atomic.AtomicReference;

public abstract class CosmosItemOperationBase
implements CosmosItemOperation {
    private final AtomicReference<Integer> serializedLengthReference = new AtomicReference<Object>(null);
    private final AtomicReference<JsonSerializable> serializedOperation = new AtomicReference<Object>(null);

    public abstract CosmosItemSerializer getEffectiveItemSerializerForResult();

    abstract JsonSerializable getSerializedOperationInternal(CosmosItemSerializer var1);

    public JsonSerializable getSerializedOperation(CosmosItemSerializer effectiveItemSerializer) {
        if (this.serializedOperation.get() == null) {
            this.serializedOperation.compareAndSet(null, this.getSerializedOperationInternal(effectiveItemSerializer));
        }
        return this.serializedOperation.get();
    }

    public int getSerializedLength(CosmosItemSerializer effectiveItemSerializer) {
        if (this.serializedLengthReference.get() == null) {
            this.serializedLengthReference.compareAndSet(null, this.getSerializedLengthInternal(effectiveItemSerializer));
        }
        return this.serializedLengthReference.get();
    }

    private int getSerializedLengthInternal(CosmosItemSerializer effectiveItemSerializer) {
        JsonSerializable operationSerializable = this.getSerializedOperation(effectiveItemSerializer);
        String serializedValue = operationSerializable.toString();
        return serializedValue.codePointCount(0, serializedValue.length());
    }
}

