/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyRangeImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class FeedRangeInternalDeserializer
extends StdDeserializer<FeedRangeInternal> {
    private static final long serialVersionUID = 1L;

    public FeedRangeInternalDeserializer() {
        this(null);
    }

    public FeedRangeInternalDeserializer(Class<?> vc) {
        super(vc);
    }

    public FeedRangeInternal deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)parser.getCodec().readTree(parser);
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        return FeedRangeInternalDeserializer.deserializeFeedRange(rootNode, mapper, parser);
    }

    public static FeedRangeInternal deserializeFeedRange(JsonNode rootNode, ObjectMapper mapper, JsonParser parser) throws JsonMappingException {
        Preconditions.checkNotNull(rootNode, "Argument 'rootNode' must not be null.");
        Preconditions.checkNotNull(mapper, "Argument 'mapper' must not be null.");
        Preconditions.checkNotNull(parser, "Argument 'parser' must not be null.");
        JsonNode rangeNode = rootNode.get("Range");
        if (rangeNode != null && rangeNode.isObject()) {
            Range<String> range = new Range<String>((ObjectNode)rangeNode);
            return new FeedRangeEpkImpl(range);
        }
        JsonNode pkNode = rootNode.get("PK");
        if (pkNode != null && pkNode.isArray()) {
            PartitionKeyInternal pk = (PartitionKeyInternal)mapper.convertValue((Object)pkNode, PartitionKeyInternal.class);
            return new FeedRangePartitionKeyImpl(pk);
        }
        JsonNode pkRangeIdNode = rootNode.get("PKRangeId");
        if (pkRangeIdNode != null && pkRangeIdNode.isTextual()) {
            return new FeedRangePartitionKeyRangeImpl(pkRangeIdNode.asText());
        }
        throw JsonMappingException.from((JsonParser)parser, (String)"Unknown feed range type");
    }
}

