/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.StoredProcedure;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosStoredProcedureProperties {
    private StoredProcedure storedProcedure;

    CosmosStoredProcedureProperties() {
        this.storedProcedure = new StoredProcedure();
    }

    public CosmosStoredProcedureProperties setId(String id) {
        this.storedProcedure.setId(id);
        return this;
    }

    CosmosStoredProcedureProperties(ObjectNode jsonNode) {
        this.storedProcedure = new StoredProcedure(jsonNode);
    }

    public CosmosStoredProcedureProperties(String id, String body) {
        this.storedProcedure = new StoredProcedure();
        this.storedProcedure.setId(id);
        this.storedProcedure.setBody(body);
    }

    public String getBody() {
        return this.storedProcedure.getBody();
    }

    public CosmosStoredProcedureProperties setBody(String body) {
        this.storedProcedure.setBody(body);
        return this;
    }

    Resource getResource() {
        return this.storedProcedure;
    }

    public String getId() {
        return this.storedProcedure.getId();
    }

    String getResourceId() {
        return this.storedProcedure.getResourceId();
    }

    public Instant getTimestamp() {
        return this.storedProcedure.getTimestamp();
    }

    public String getETag() {
        return this.storedProcedure.getETag();
    }

    static List<CosmosStoredProcedureProperties> getFromV2Results(List<StoredProcedure> results) {
        return results.stream().map(sproc -> new CosmosStoredProcedureProperties(sproc.getPropertyBag())).collect(Collectors.toList());
    }
}

