/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.User;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosUserProperties {
    private User user;

    public CosmosUserProperties() {
        this.user = new User();
    }

    public CosmosUserProperties setId(String id) {
        this.user.setId(id);
        return this;
    }

    CosmosUserProperties(ObjectNode jsonNode) {
        this.user = new User(jsonNode);
    }

    CosmosUserProperties(User user) {
        this.user = user;
    }

    String getPermissionsLink() {
        return this.user.getPermissionsLink();
    }

    User getV2User() {
        return new User(this.user.getPropertyBag());
    }

    Resource getResource() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    String getResourceId() {
        return this.user.getResourceId();
    }

    public Instant getTimestamp() {
        return this.user.getTimestamp();
    }

    public String getETag() {
        return this.user.getETag();
    }

    static List<CosmosUserProperties> getFromV2Results(List<User> results) {
        return results.stream().map(CosmosUserProperties::new).collect(Collectors.toList());
    }
}

