/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;

public final class SqlParameter {
    private JsonSerializable jsonSerializable;

    public SqlParameter() {
        this.jsonSerializable = new JsonSerializable();
    }

    SqlParameter(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public SqlParameter(String name, Object value) {
        this.jsonSerializable = new JsonSerializable();
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this.jsonSerializable.getString("name");
    }

    public SqlParameter setName(String name) {
        this.jsonSerializable.set("name", name, CosmosItemSerializer.DEFAULT_SERIALIZER);
        return this;
    }

    public <T> T getValue(Class<T> classType) {
        return this.jsonSerializable.getObject("value", classType, new boolean[0]);
    }

    public SqlParameter setValue(Object value) {
        this.jsonSerializable.set("value", value, CosmosItemSerializer.DEFAULT_SERIALIZER);
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlParameter that = (SqlParameter)o;
        return Objects.equals(this.jsonSerializable, that.jsonSerializable);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializable);
    }
}

