/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.util;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.paging.ContinuablePagedFlux;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.DiagnosticsProvider;
import com.azure.cosmos.implementation.FeedOperationState;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.models.FeedResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.util.context.ContextView;

public final class CosmosPagedFlux<T>
extends ContinuablePagedFlux<String, T, FeedResponse<T>> {
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.CosmosDiagnosticsContextAccessor ctxAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.getCosmosDiagnosticsContextAccessor();
    private final Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> optionsFluxFunction;
    private final Consumer<FeedResponse<T>> feedResponseConsumer;
    private final int defaultPageSize;

    CosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> optionsFluxFunction) {
        this(optionsFluxFunction, null, -1);
    }

    CosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> optionsFluxFunction, Consumer<FeedResponse<T>> feedResponseConsumer) {
        this(optionsFluxFunction, feedResponseConsumer, -1);
    }

    CosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> optionsFluxFunction, Consumer<FeedResponse<T>> feedResponseConsumer, int defaultPageSize) {
        this.optionsFluxFunction = optionsFluxFunction;
        this.feedResponseConsumer = feedResponseConsumer;
        this.defaultPageSize = defaultPageSize;
    }

    public CosmosPagedFlux<T> handle(Consumer<FeedResponse<T>> newFeedResponseConsumer) {
        if (this.feedResponseConsumer != null) {
            return new CosmosPagedFlux<T>(this.optionsFluxFunction, this.feedResponseConsumer.andThen(newFeedResponseConsumer));
        }
        return new CosmosPagedFlux<T>(this.optionsFluxFunction, newFeedResponseConsumer);
    }

    public Flux<FeedResponse<T>> byPage() {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = this.createCosmosPagedFluxOptions();
        return FluxUtil.fluxContext(context -> this.byPage(cosmosPagedFluxOptions, (Context)context));
    }

    public Flux<FeedResponse<T>> byPage(String continuationToken) {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = this.createCosmosPagedFluxOptions();
        cosmosPagedFluxOptions.setRequestContinuation(continuationToken);
        return FluxUtil.fluxContext(context -> this.byPage(cosmosPagedFluxOptions, (Context)context));
    }

    public Flux<FeedResponse<T>> byPage(int preferredPageSize) {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = this.createCosmosPagedFluxOptions();
        cosmosPagedFluxOptions.setMaxItemCount(preferredPageSize);
        return FluxUtil.fluxContext(context -> this.byPage(cosmosPagedFluxOptions, (Context)context));
    }

    public Flux<FeedResponse<T>> byPage(String continuationToken, int preferredPageSize) {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = this.createCosmosPagedFluxOptions();
        cosmosPagedFluxOptions.setRequestContinuation(continuationToken);
        cosmosPagedFluxOptions.setMaxItemCount(preferredPageSize);
        return FluxUtil.fluxContext(context -> this.byPage(cosmosPagedFluxOptions, (Context)context));
    }

    public void subscribe(CoreSubscriber<? super T> coreSubscriber) {
        Flux<FeedResponse<T>> pagedResponse = this.byPage();
        pagedResponse.flatMap(tFeedResponse -> {
            IterableStream elements = tFeedResponse.getElements();
            if (elements == null) {
                return Flux.empty();
            }
            return Flux.fromIterable(elements);
        }).subscribe(coreSubscriber);
    }

    CosmosPagedFlux<T> withDefaultPageSize(int pageSize) {
        return new CosmosPagedFlux<T>(this.optionsFluxFunction, this.feedResponseConsumer, pageSize);
    }

    private CosmosPagedFluxOptions createCosmosPagedFluxOptions() {
        CosmosPagedFluxOptions cosmosPagedFluxOptions = new CosmosPagedFluxOptions();
        if (this.defaultPageSize > 0) {
            cosmosPagedFluxOptions.setMaxItemCount(this.defaultPageSize);
        }
        return cosmosPagedFluxOptions;
    }

    private Flux<FeedResponse<T>> wrapWithTracingIfEnabled(CosmosPagedFluxOptions pagedFluxOptions, Flux<FeedResponse<T>> publisher, AtomicLong feedResponseConsumerLatencyInNanos, Context context) {
        FeedOperationState state = pagedFluxOptions.getFeedOperationState();
        DiagnosticsProvider tracerProvider = state != null ? state.getDiagnosticsProvider() : null;
        Object lockHolder = new Object();
        if (tracerProvider == null) {
            return publisher.doOnEach(signal -> {
                FeedResponse response = (FeedResponse)signal.get();
                Object object = lockHolder;
                synchronized (object) {
                    switch (signal.getType()) {
                        case ON_COMPLETE: 
                        case ON_NEXT: {
                            DiagnosticsProvider.recordFeedResponse(this.feedResponseConsumer, pagedFluxOptions.getFeedOperationState(), () -> pagedFluxOptions.getSamplingRateSnapshot(), tracerProvider, response, feedResponseConsumerLatencyInNanos);
                            break;
                        }
                    }
                }
            });
        }
        if (!tracerProvider.isEnabled()) {
            pagedFluxOptions.setSamplingRateSnapshot(0.0, true);
        }
        boolean isSampledOut = tracerProvider.shouldSampleOutOperation(pagedFluxOptions);
        double samplingRateSnapshot = pagedFluxOptions.getSamplingRateSnapshot();
        Flux result = tracerProvider.runUnderSpanInContext(publisher).doOnEach(signal -> {
            FeedResponse response = (FeedResponse)signal.get();
            Context traceCtx = DiagnosticsProvider.getContextFromReactorOrNull(signal.getContextView());
            Object object = lockHolder;
            synchronized (object) {
                switch (signal.getType()) {
                    case ON_COMPLETE: {
                        if (response != null) {
                            DiagnosticsProvider.recordFeedResponse(this.feedResponseConsumer, pagedFluxOptions.getFeedOperationState(), () -> pagedFluxOptions.getSamplingRateSnapshot(), tracerProvider, response, feedResponseConsumerLatencyInNanos);
                        }
                        state.mergeDiagnosticsContext();
                        CosmosDiagnosticsContext ctxSnapshot = state.getDiagnosticsContextSnapshot();
                        ctxAccessor.setSamplingRateSnapshot(ctxSnapshot, samplingRateSnapshot, isSampledOut);
                        tracerProvider.recordFeedResponseConsumerLatency(signal, ctxSnapshot, Duration.ofNanos(feedResponseConsumerLatencyInNanos.get()));
                        tracerProvider.endSpan(ctxSnapshot, traceCtx, ctxAccessor.isEmptyCompletion(ctxSnapshot), isSampledOut);
                        break;
                    }
                    case ON_NEXT: {
                        DiagnosticsProvider.recordFeedResponse(this.feedResponseConsumer, pagedFluxOptions.getFeedOperationState(), () -> pagedFluxOptions.getSamplingRateSnapshot(), tracerProvider, response, feedResponseConsumerLatencyInNanos);
                        state.mergeDiagnosticsContext();
                        CosmosDiagnosticsContext ctxSnapshotOnNext = state.getDiagnosticsContextSnapshot();
                        ctxAccessor.setSamplingRateSnapshot(ctxSnapshotOnNext, samplingRateSnapshot, isSampledOut);
                        tracerProvider.endSpan(ctxSnapshotOnNext, traceCtx, false, isSampledOut);
                        state.resetDiagnosticsContext();
                        DiagnosticsProvider.setContextInReactor(tracerProvider.startSpan(state.getSpanName(), state.getDiagnosticsContextSnapshot(), traceCtx, isSampledOut));
                        break;
                    }
                    case ON_ERROR: {
                        state.mergeDiagnosticsContext();
                        CosmosDiagnosticsContext ctxSnapshotOnError = state.getDiagnosticsContextSnapshot();
                        ctxAccessor.setSamplingRateSnapshot(ctxSnapshotOnError, samplingRateSnapshot, isSampledOut);
                        tracerProvider.recordFeedResponseConsumerLatency(signal, ctxSnapshotOnError, Duration.ofNanos(feedResponseConsumerLatencyInNanos.get()));
                        tracerProvider.endSpan(state.getDiagnosticsContextSnapshot(), traceCtx, signal.getThrowable(), isSampledOut);
                        break;
                    }
                }
            }
        });
        return Flux.deferContextual(reactorCtx -> result.doOnCancel(() -> {
            Context traceCtx = DiagnosticsProvider.getContextFromReactorOrNull(reactorCtx);
            Object object = lockHolder;
            synchronized (object) {
                state.mergeDiagnosticsContext();
                CosmosDiagnosticsContext ctxSnapshot = state.getDiagnosticsContextSnapshot();
                ctxAccessor.setSamplingRateSnapshot(ctxSnapshot, samplingRateSnapshot, isSampledOut);
                tracerProvider.endSpan(ctxSnapshot, traceCtx, false, isSampledOut);
            }
        }).doOnComplete(() -> {
            Context traceCtx = DiagnosticsProvider.getContextFromReactorOrNull(reactorCtx);
            Object object = lockHolder;
            synchronized (object) {
                state.mergeDiagnosticsContext();
                CosmosDiagnosticsContext ctxSnapshot = state.getDiagnosticsContextSnapshot();
                ctxAccessor.setSamplingRateSnapshot(ctxSnapshot, samplingRateSnapshot, isSampledOut);
                tracerProvider.endSpan(ctxSnapshot, traceCtx, ctxAccessor.isEmptyCompletion(ctxSnapshot), isSampledOut);
            }
        })).contextWrite((ContextView)DiagnosticsProvider.setContextInReactor(tracerProvider.startSpan(state.getSpanName(), state.getDiagnosticsContextSnapshot(), context, isSampledOut)));
    }

    private Flux<FeedResponse<T>> byPage(CosmosPagedFluxOptions pagedFluxOptions, Context context) {
        AtomicReference startTime = new AtomicReference();
        AtomicLong feedResponseConsumerLatencyInNanos = new AtomicLong(0L);
        Flux result = this.wrapWithTracingIfEnabled(pagedFluxOptions, this.optionsFluxFunction.apply(pagedFluxOptions), feedResponseConsumerLatencyInNanos, context).doOnSubscribe(ignoredValue -> {
            startTime.set(Instant.now());
            feedResponseConsumerLatencyInNanos.set(0L);
        });
        return result;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosPageFluxHelper.setCosmosPageFluxAccessor(CosmosPagedFlux::new);
    }

    static {
        CosmosPagedFlux.initialize();
    }
}

