/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryImpl;
import com.azure.data.schemaregistry.implementation.SchemaRegistryHelper;
import com.azure.data.schemaregistry.implementation.models.ErrorException;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentHeaders;
import com.azure.data.schemaregistry.models.SchemaFormat;
import com.azure.data.schemaregistry.models.SchemaProperties;
import com.azure.data.schemaregistry.models.SchemaRegistrySchema;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SchemaRegistryClientBuilder.class, isAsync=true)
public final class SchemaRegistryAsyncClient {
    private final ClientLogger logger = new ClientLogger(SchemaRegistryAsyncClient.class);
    private final AzureSchemaRegistryImpl restService;

    SchemaRegistryAsyncClient(AzureSchemaRegistryImpl restService) {
        this.restService = restService;
        new SchemaProperties("", SchemaFormat.AVRO);
    }

    public String getFullyQualifiedNamespace() {
        return this.restService.getEndpoint();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaProperties> registerSchema(String groupName, String name, String schemaDefinition, SchemaFormat format) {
        return this.registerSchemaWithResponse(groupName, name, schemaDefinition, format).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaProperties>> registerSchemaWithResponse(String groupName, String name, String schemaDefinition, SchemaFormat format) {
        return FluxUtil.withContext(context -> this.registerSchemaWithResponse(groupName, name, schemaDefinition, format, (Context)context));
    }

    Mono<Response<SchemaProperties>> registerSchemaWithResponse(String groupName, String name, String schemaDefinition, SchemaFormat format, Context context) {
        if (Objects.isNull(groupName)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'groupName' should not be null."));
        }
        if (Objects.isNull(name)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'name' should not be null."));
        }
        if (Objects.isNull(schemaDefinition)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'schemaDefinition' should not be null."));
        }
        if (Objects.isNull((Object)format)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'format' should not be null."));
        }
        this.logger.verbose("Registering schema. Group: '{}', name: '{}', serialization type: '{}', payload: '{}'", new Object[]{groupName, name, format, schemaDefinition});
        String contentType = SchemaRegistryAsyncClient.getContentType(format);
        return this.restService.getSchemas().registerWithResponseAsync(groupName, name, schemaDefinition, contentType, context).map(response -> {
            SchemaProperties registered = SchemaRegistryHelper.getSchemaProperties(response);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)registered);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaRegistrySchema> getSchema(String schemaId) {
        return this.getSchemaWithResponse(schemaId).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaRegistrySchema>> getSchemaWithResponse(String schemaId) {
        return FluxUtil.withContext(context -> this.getSchemaWithResponse(schemaId, (Context)context));
    }

    Mono<Response<SchemaRegistrySchema>> getSchemaWithResponse(String schemaId, Context context) {
        if (Objects.isNull(schemaId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'schemaId' should not be null."));
        }
        return this.restService.getSchemas().getByIdWithResponseAsync(schemaId, context).onErrorMap(ErrorException.class, SchemaRegistryAsyncClient::remapError).map(response -> {
            SchemaProperties schemaObject = SchemaRegistryHelper.getSchemaProperties(response);
            String schema = new String((byte[])response.getValue(), StandardCharsets.UTF_8);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new SchemaRegistrySchema(schemaObject, schema));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaProperties> getSchemaProperties(String groupName, String name, String schemaDefinition, SchemaFormat format) {
        return this.getSchemaPropertiesWithResponse(groupName, name, schemaDefinition, format).map(response -> (SchemaProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaProperties>> getSchemaPropertiesWithResponse(String groupName, String name, String schemaDefinition, SchemaFormat format) {
        return FluxUtil.withContext(context -> this.getSchemaPropertiesWithResponse(groupName, name, schemaDefinition, format, (Context)context));
    }

    Mono<Response<SchemaProperties>> getSchemaPropertiesWithResponse(String groupName, String name, String schemaDefinition, SchemaFormat format, Context context) {
        if (Objects.isNull(groupName)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'groupName' cannot be null."));
        }
        if (Objects.isNull(name)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'name' cannot be null."));
        }
        if (Objects.isNull(schemaDefinition)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'schemaDefinition' cannot be null."));
        }
        if (Objects.isNull((Object)format)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'format' cannot be null."));
        }
        if (context == null) {
            context = Context.NONE;
        }
        String contentType = SchemaRegistryAsyncClient.getContentType(format);
        return this.restService.getSchemas().queryIdByContentWithResponseAsync(groupName, name, schemaDefinition, contentType, context).onErrorMap(ErrorException.class, SchemaRegistryAsyncClient::remapError).map(response -> {
            SchemasQueryIdByContentHeaders deserializedHeaders = (SchemasQueryIdByContentHeaders)response.getDeserializedHeaders();
            SchemaProperties properties = SchemaRegistryHelper.getSchemaProperties(response);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)properties);
        });
    }

    private static Throwable remapError(ErrorException error) {
        if (error.getResponse().getStatusCode() == 404) {
            String message = error.getValue() != null && error.getValue().getError() != null ? error.getValue().getError().getMessage() : error.getMessage();
            return new ResourceNotFoundException(message, error.getResponse(), (Throwable)((Object)error));
        }
        return error;
    }

    private static String getContentType(SchemaFormat schemaFormat) {
        return "application/json; serialization=" + (Object)((Object)schemaFormat);
    }
}

