/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.models.TableServiceError;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.implementation.models.TableServiceErrorOdataError;
import com.azure.data.tables.implementation.models.TableServiceErrorOdataErrorMessage;
import com.azure.data.tables.models.TableServiceException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TableUtils {
    private static final String UTF8_CHARSET = "UTF-8";

    private TableUtils() {
        throw new UnsupportedOperationException("Cannot instantiate TablesUtils");
    }

    public static com.azure.data.tables.models.TableServiceError toTableServiceError(TableServiceError tableServiceError) {
        TableServiceErrorOdataError odataError;
        String errorCode = null;
        String errorMessage = null;
        if (tableServiceError != null && (odataError = tableServiceError.getOdataError()) != null) {
            errorCode = odataError.getCode();
            TableServiceErrorOdataErrorMessage odataErrorMessage = odataError.getMessage();
            if (odataErrorMessage != null) {
                errorMessage = odataErrorMessage.getValue();
            }
        }
        return new com.azure.data.tables.models.TableServiceError(errorCode, errorMessage);
    }

    public static TableServiceException toTableServiceException(TableServiceErrorException exception) {
        return new TableServiceException(exception.getMessage(), exception.getResponse(), TableUtils.toTableServiceError(exception.getValue()));
    }

    public static Throwable mapThrowableToTableServiceException(Throwable throwable) {
        if (throwable instanceof TableServiceErrorException) {
            return TableUtils.toTableServiceException((TableServiceErrorException)((Object)throwable));
        }
        return throwable;
    }

    public static <T> Mono<T> applyOptionalTimeout(Mono<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static <T> Flux<T> applyOptionalTimeout(Flux<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static <T> T blockWithOptionalTimeout(Mono<T> response, Duration timeout) {
        if (timeout == null) {
            return (T)response.block();
        }
        return (T)response.block(timeout);
    }

    public static <E extends HttpResponseException> Mono<Response<Void>> swallowExceptionForStatusCode(int statusCode, E httpResponseException, ClientLogger logger) {
        HttpResponse httpResponse = httpResponseException.getResponse();
        if (httpResponse.getStatusCode() == statusCode) {
            return Mono.just((Object)new SimpleResponse(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null));
        }
        return FluxUtil.monoError((ClientLogger)logger, httpResponseException);
    }

    public static Map<String, String[]> parseQueryStringSplitValues(String queryString) {
        return TableUtils.parseQueryStringHelper(queryString, value -> {
            String[] v = value.split(",");
            String[] ret = new String[v.length];
            for (int i = 0; i < v.length; ++i) {
                ret[i] = TableUtils.urlDecode(v[i]);
            }
            return ret;
        });
    }

    private static <T> Map<String, T> parseQueryStringHelper(String queryString, Function<String, T> valueParser) {
        TreeMap<String, T> pieces = new TreeMap<String, T>();
        if (CoreUtils.isNullOrEmpty((CharSequence)queryString)) {
            return pieces;
        }
        for (String kvp : queryString.split("&")) {
            int equalIndex = kvp.indexOf("=");
            String key = TableUtils.urlDecode(kvp.substring(0, equalIndex).toLowerCase(Locale.ROOT));
            T value = valueParser.apply(kvp.substring(equalIndex + 1));
            pieces.putIfAbsent(key, value);
        }
        return pieces;
    }

    public static String urlDecode(String stringToDecode) {
        if (CoreUtils.isNullOrEmpty((CharSequence)stringToDecode)) {
            return "";
        }
        if (stringToDecode.contains("+")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m = 0; m < stringToDecode.length(); ++m) {
                if (stringToDecode.charAt(m) != '+') continue;
                if (m > startDex) {
                    outBuilder.append(TableUtils.decode(stringToDecode.substring(startDex, m)));
                }
                outBuilder.append("+");
                startDex = m + 1;
            }
            if (startDex != stringToDecode.length()) {
                outBuilder.append(TableUtils.decode(stringToDecode.substring(startDex)));
            }
            return outBuilder.toString();
        }
        return TableUtils.decode(stringToDecode);
    }

    private static String decode(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlEncode(String stringToEncode) {
        if (stringToEncode == null) {
            return null;
        }
        if (stringToEncode.length() == 0) {
            return "";
        }
        if (stringToEncode.contains(" ")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m = 0; m < stringToEncode.length(); ++m) {
                if (stringToEncode.charAt(m) != ' ') continue;
                if (m > startDex) {
                    outBuilder.append(TableUtils.encode(stringToEncode.substring(startDex, m)));
                }
                outBuilder.append("%20");
                startDex = m + 1;
            }
            if (startDex != stringToEncode.length()) {
                outBuilder.append(TableUtils.encode(stringToEncode.substring(startDex)));
            }
            return outBuilder.toString();
        }
        return TableUtils.encode(stringToEncode);
    }

    private static String encode(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

