/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.TableAsyncClient;
import com.azure.data.tables.TableClientBuilder;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.data.tables.TableServiceVersion;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.AzureTableImplBuilder;
import com.azure.data.tables.implementation.ModelHelper;
import com.azure.data.tables.implementation.TableAccountSasGenerator;
import com.azure.data.tables.implementation.TableSasUtils;
import com.azure.data.tables.implementation.TableUtils;
import com.azure.data.tables.implementation.models.CorsRule;
import com.azure.data.tables.implementation.models.GeoReplication;
import com.azure.data.tables.implementation.models.Logging;
import com.azure.data.tables.implementation.models.Metrics;
import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.data.tables.implementation.models.QueryOptions;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.RetentionPolicy;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.implementation.models.TableQueryResponse;
import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.data.tables.implementation.models.TableServiceProperties;
import com.azure.data.tables.implementation.models.TableServiceStats;
import com.azure.data.tables.implementation.models.TablesQueryHeaders;
import com.azure.data.tables.models.ListTablesOptions;
import com.azure.data.tables.models.TableItem;
import com.azure.data.tables.models.TableServiceCorsRule;
import com.azure.data.tables.models.TableServiceException;
import com.azure.data.tables.models.TableServiceGeoReplication;
import com.azure.data.tables.models.TableServiceGeoReplicationStatus;
import com.azure.data.tables.models.TableServiceLogging;
import com.azure.data.tables.models.TableServiceMetrics;
import com.azure.data.tables.models.TableServiceRetentionPolicy;
import com.azure.data.tables.models.TableServiceStatistics;
import com.azure.data.tables.sas.TableAccountSasSignatureValues;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=TableServiceClientBuilder.class, isAsync=true)
public final class TableServiceAsyncClient {
    private final ClientLogger logger = new ClientLogger(TableServiceAsyncClient.class);
    private final AzureTableImpl implementation;
    private final String accountName;
    private final HttpPipeline pipeline;

    TableServiceAsyncClient(HttpPipeline pipeline, String url, TableServiceVersion serviceVersion, SerializerAdapter serializerAdapter) {
        try {
            URI uri = URI.create(url);
            this.accountName = uri.getHost().split("\\.", 2)[0];
            this.logger.verbose("Table Service URI: {}", new Object[]{uri});
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw this.logger.logExceptionAsError(ex);
        }
        this.implementation = new AzureTableImplBuilder().serializerAdapter(serializerAdapter).url(url).pipeline(pipeline).version(serviceVersion.getVersion()).buildClient();
        this.pipeline = this.implementation.getHttpPipeline();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getServiceEndpoint() {
        return this.implementation.getUrl();
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    AzureTableImpl getImplementation() {
        return this.implementation;
    }

    ClientLogger getLogger() {
        return this.logger;
    }

    public TableServiceVersion getServiceVersion() {
        return TableServiceVersion.fromString(this.implementation.getVersion());
    }

    public String generateAccountSas(TableAccountSasSignatureValues tableAccountSasSignatureValues) {
        AzureNamedKeyCredential azureNamedKeyCredential = TableSasUtils.extractNamedKeyCredential(this.getHttpPipeline());
        if (azureNamedKeyCredential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot generate a SAS token with a client that is not authenticated with an AzureNamedKeyCredential."));
        }
        return new TableAccountSasGenerator(tableAccountSasSignatureValues, azureNamedKeyCredential).getSas();
    }

    public TableAsyncClient getTableClient(String tableName) {
        return new TableClientBuilder().pipeline(this.implementation.getHttpPipeline()).serviceVersion(this.getServiceVersion()).endpoint(this.getServiceEndpoint()).tableName(tableName).buildAsyncClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableAsyncClient> createTable(String tableName) {
        return this.createTableWithResponse(tableName).flatMap(response -> Mono.justOrEmpty((Object)((TableAsyncClient)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableAsyncClient>> createTableWithResponse(String tableName) {
        return FluxUtil.withContext(context -> this.createTableWithResponse(tableName, (Context)context));
    }

    Mono<Response<TableAsyncClient>> createTableWithResponse(String tableName, Context context) {
        context = context == null ? Context.NONE : context;
        TableProperties properties = new TableProperties().setTableName(tableName);
        try {
            return this.implementation.getTables().createWithResponseAsync(properties, null, ResponseFormat.RETURN_NO_CONTENT, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, (Object)this.getTableClient(tableName)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableAsyncClient> createTableIfNotExists(String tableName) {
        return this.createTableIfNotExistsWithResponse(tableName).flatMap(response -> Mono.justOrEmpty((Object)((TableAsyncClient)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableAsyncClient>> createTableIfNotExistsWithResponse(String tableName) {
        return FluxUtil.withContext(context -> this.createTableIfNotExistsWithResponse(tableName, (Context)context));
    }

    Mono<Response<TableAsyncClient>> createTableIfNotExistsWithResponse(String tableName, Context context) {
        return this.createTableWithResponse(tableName, context).onErrorResume(e -> e instanceof TableServiceException && ((TableServiceException)((Object)((Object)e))).getResponse() != null && ((TableServiceException)((Object)((Object)e))).getResponse().getStatusCode() == 409, e -> {
            HttpResponse response = ((TableServiceException)((Object)((Object)e))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTable(String tableName) {
        return this.deleteTableWithResponse(tableName).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTableWithResponse(String tableName) {
        return FluxUtil.withContext(context -> this.deleteTableWithResponse(tableName, (Context)context));
    }

    Mono<Response<Void>> deleteTableWithResponse(String tableName, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.implementation.getTables().deleteWithResponseAsync(tableName, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, null)).onErrorResume(TableServiceException.class, e -> TableUtils.swallowExceptionForStatusCode(404, e, this.logger));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TableItem> listTables() {
        return this.listTables(new ListTablesOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TableItem> listTables(ListTablesOptions options) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listTablesFirstPage((Context)context, options)), token -> FluxUtil.withContext(context -> this.listTablesNextPage((String)token, (Context)context, options)));
    }

    PagedFlux<TableItem> listTables(ListTablesOptions options, Context context, Duration timeout) {
        return new PagedFlux(() -> TableUtils.applyOptionalTimeout(this.listTablesFirstPage(context, options), timeout), token -> TableUtils.applyOptionalTimeout(this.listTablesNextPage((String)token, context, options), timeout));
    }

    private Mono<PagedResponse<TableItem>> listTablesFirstPage(Context context, ListTablesOptions options) {
        try {
            return this.listTables(null, context, options);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private Mono<PagedResponse<TableItem>> listTablesNextPage(String token, Context context, ListTablesOptions options) {
        try {
            return this.listTables(token, context, options);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private Mono<PagedResponse<TableItem>> listTables(String nextTableName, Context context, ListTablesOptions options) {
        context = context == null ? Context.NONE : context;
        QueryOptions queryOptions = new QueryOptions().setFilter(options.getFilter()).setTop(options.getTop()).setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        try {
            return this.implementation.getTables().queryWithResponseAsync(null, nextTableName, queryOptions, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).flatMap(response -> {
                TableQueryResponse tableQueryResponse = (TableQueryResponse)response.getValue();
                if (tableQueryResponse == null) {
                    return Mono.empty();
                }
                List<TableResponseProperties> tableResponsePropertiesList = tableQueryResponse.getValue();
                if (tableResponsePropertiesList == null) {
                    return Mono.empty();
                }
                List<TableItem> tables = tableResponsePropertiesList.stream().map(ModelHelper::createItem).collect(Collectors.toList());
                return Mono.just((Object)new TablePaged((Response<TableQueryResponse>)response, tables, ((TablesQueryHeaders)response.getDeserializedHeaders()).getXMsContinuationNextTableName()));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<com.azure.data.tables.models.TableServiceProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<com.azure.data.tables.models.TableServiceProperties>> getPropertiesWithResponse() {
        return FluxUtil.withContext(this::getPropertiesWithResponse);
    }

    Mono<Response<com.azure.data.tables.models.TableServiceProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.implementation.getServices().getPropertiesWithResponseAsync(null, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, (Object)this.toTableServiceProperties((TableServiceProperties)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private com.azure.data.tables.models.TableServiceProperties toTableServiceProperties(TableServiceProperties tableServiceProperties) {
        if (tableServiceProperties == null) {
            return null;
        }
        return new com.azure.data.tables.models.TableServiceProperties().setLogging(this.toTableServiceLogging(tableServiceProperties.getLogging())).setHourMetrics(this.toTableServiceMetrics(tableServiceProperties.getHourMetrics())).setMinuteMetrics(this.toTableServiceMetrics(tableServiceProperties.getMinuteMetrics())).setCorsRules(tableServiceProperties.getCors() == null ? null : tableServiceProperties.getCors().stream().map(this::toTablesServiceCorsRule).collect(Collectors.toList()));
    }

    private TableServiceLogging toTableServiceLogging(Logging logging) {
        if (logging == null) {
            return null;
        }
        return new TableServiceLogging().setAnalyticsVersion(logging.getVersion()).setDeleteLogged(logging.isDelete()).setReadLogged(logging.isRead()).setWriteLogged(logging.isWrite()).setRetentionPolicy(this.toTableServiceRetentionPolicy(logging.getRetentionPolicy()));
    }

    private TableServiceRetentionPolicy toTableServiceRetentionPolicy(RetentionPolicy retentionPolicy) {
        if (retentionPolicy == null) {
            return null;
        }
        return new TableServiceRetentionPolicy().setEnabled(retentionPolicy.isEnabled()).setDaysToRetain(retentionPolicy.getDays());
    }

    private TableServiceMetrics toTableServiceMetrics(Metrics metrics) {
        if (metrics == null) {
            return null;
        }
        return new TableServiceMetrics().setVersion(metrics.getVersion()).setEnabled(metrics.isEnabled()).setIncludeApis(metrics.isIncludeAPIs()).setRetentionPolicy(this.toTableServiceRetentionPolicy(metrics.getRetentionPolicy()));
    }

    private TableServiceCorsRule toTablesServiceCorsRule(CorsRule corsRule) {
        if (corsRule == null) {
            return null;
        }
        return new TableServiceCorsRule().setAllowedOrigins(corsRule.getAllowedOrigins()).setAllowedMethods(corsRule.getAllowedMethods()).setAllowedHeaders(corsRule.getAllowedHeaders()).setExposedHeaders(corsRule.getExposedHeaders()).setMaxAgeInSeconds(corsRule.getMaxAgeInSeconds());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setProperties(com.azure.data.tables.models.TableServiceProperties tableServiceProperties) {
        return this.setPropertiesWithResponse(tableServiceProperties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesWithResponse(com.azure.data.tables.models.TableServiceProperties tableServiceProperties) {
        return FluxUtil.withContext(context -> this.setPropertiesWithResponse(tableServiceProperties, (Context)context));
    }

    Mono<Response<Void>> setPropertiesWithResponse(com.azure.data.tables.models.TableServiceProperties tableServiceProperties, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.implementation.getServices().setPropertiesWithResponseAsync(this.toImplTableServiceProperties(tableServiceProperties), null, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, null));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private TableServiceProperties toImplTableServiceProperties(com.azure.data.tables.models.TableServiceProperties tableServiceProperties) {
        return new TableServiceProperties().setLogging(this.toLogging(tableServiceProperties.getLogging())).setHourMetrics(this.toMetrics(tableServiceProperties.getHourMetrics())).setMinuteMetrics(this.toMetrics(tableServiceProperties.getMinuteMetrics())).setCors(tableServiceProperties.getCorsRules() == null ? null : tableServiceProperties.getCorsRules().stream().map(this::toCorsRule).collect(Collectors.toList()));
    }

    private Logging toLogging(TableServiceLogging tableServiceLogging) {
        if (tableServiceLogging == null) {
            return null;
        }
        return new Logging().setVersion(tableServiceLogging.getAnalyticsVersion()).setDelete(tableServiceLogging.isDeleteLogged()).setRead(tableServiceLogging.isReadLogged()).setWrite(tableServiceLogging.isWriteLogged()).setRetentionPolicy(this.toRetentionPolicy(tableServiceLogging.getRetentionPolicy()));
    }

    private RetentionPolicy toRetentionPolicy(TableServiceRetentionPolicy tableServiceRetentionPolicy) {
        if (tableServiceRetentionPolicy == null) {
            return null;
        }
        return new RetentionPolicy().setEnabled(tableServiceRetentionPolicy.isEnabled()).setDays(tableServiceRetentionPolicy.getDaysToRetain());
    }

    private Metrics toMetrics(TableServiceMetrics tableServiceMetrics) {
        if (tableServiceMetrics == null) {
            return null;
        }
        return new Metrics().setVersion(tableServiceMetrics.getVersion()).setEnabled(tableServiceMetrics.isEnabled()).setIncludeAPIs(tableServiceMetrics.isIncludeApis()).setRetentionPolicy(this.toRetentionPolicy(tableServiceMetrics.getTableServiceRetentionPolicy()));
    }

    private CorsRule toCorsRule(TableServiceCorsRule corsRule) {
        if (corsRule == null) {
            return null;
        }
        return new CorsRule().setAllowedOrigins(corsRule.getAllowedOrigins()).setAllowedMethods(corsRule.getAllowedMethods()).setAllowedHeaders(corsRule.getAllowedHeaders()).setExposedHeaders(corsRule.getExposedHeaders()).setMaxAgeInSeconds(corsRule.getMaxAgeInSeconds());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableServiceStatistics> getStatistics() {
        return this.getStatisticsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableServiceStatistics>> getStatisticsWithResponse() {
        return FluxUtil.withContext(this::getStatisticsWithResponse);
    }

    Mono<Response<TableServiceStatistics>> getStatisticsWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.implementation.getServices().getStatisticsWithResponseAsync(null, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, (Object)this.toTableServiceStatistics((TableServiceStats)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private TableServiceStatistics toTableServiceStatistics(TableServiceStats tableServiceStats) {
        if (tableServiceStats == null) {
            return null;
        }
        return new TableServiceStatistics(this.toTableServiceGeoReplication(tableServiceStats.getGeoReplication()));
    }

    private TableServiceGeoReplication toTableServiceGeoReplication(GeoReplication geoReplication) {
        if (geoReplication == null) {
            return null;
        }
        return new TableServiceGeoReplication(TableServiceGeoReplicationStatus.fromString(geoReplication.getStatus().toString()), geoReplication.getLastSyncTime());
    }

    private static class TablePaged
    implements PagedResponse<TableItem> {
        private final Response<TableQueryResponse> httpResponse;
        private final IterableStream<TableItem> tableStream;
        private final String continuationToken;

        TablePaged(Response<TableQueryResponse> httpResponse, List<TableItem> tableList, String continuationToken) {
            this.httpResponse = httpResponse;
            this.tableStream = IterableStream.of(tableList);
            this.continuationToken = continuationToken;
        }

        public int getStatusCode() {
            return this.httpResponse.getStatusCode();
        }

        public HttpHeaders getHeaders() {
            return this.httpResponse.getHeaders();
        }

        public HttpRequest getRequest() {
            return this.httpResponse.getRequest();
        }

        public IterableStream<TableItem> getElements() {
            return this.tableStream;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public void close() {
        }
    }
}

