/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.implementation.credential;

import com.azure.identity.extensions.implementation.enums.AuthProperty;
import java.util.Properties;

public class TokenCredentialProviderOptions {
    private String authorityHost = "https://login.microsoftonline.com/";
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private String clientCertificatePath;
    private String clientCertificatePassword;
    private String username;
    private String password;
    private boolean managedIdentityEnabled;
    private String tokenCredentialProviderClassName;
    private String tokenCredentialBeanName;

    public TokenCredentialProviderOptions() {
    }

    public TokenCredentialProviderOptions(Properties properties) {
        this.tenantId = AuthProperty.TENANT_ID.get(properties);
        this.clientId = AuthProperty.CLIENT_ID.get(properties);
        this.clientSecret = AuthProperty.CLIENT_SECRET.get(properties);
        this.clientCertificatePath = AuthProperty.CLIENT_CERTIFICATE_PATH.get(properties);
        this.clientCertificatePassword = AuthProperty.CLIENT_CERTIFICATE_PASSWORD.get(properties);
        this.username = AuthProperty.USERNAME.get(properties);
        this.password = AuthProperty.PASSWORD.get(properties);
        this.managedIdentityEnabled = Boolean.TRUE.equals(AuthProperty.MANAGED_IDENTITY_ENABLED.getBoolean(properties));
        this.tokenCredentialProviderClassName = AuthProperty.TOKEN_CREDENTIAL_PROVIDER_CLASS_NAME.get(properties);
        this.tokenCredentialBeanName = AuthProperty.TOKEN_CREDENTIAL_BEAN_NAME.get(properties);
        this.authorityHost = AuthProperty.AUTHORITY_HOST.get(properties);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientCertificatePath() {
        return this.clientCertificatePath;
    }

    public void setClientCertificatePath(String clientCertificatePath) {
        this.clientCertificatePath = clientCertificatePath;
    }

    public String getClientCertificatePassword() {
        return this.clientCertificatePassword;
    }

    public void setClientCertificatePassword(String clientCertificatePassword) {
        this.clientCertificatePassword = clientCertificatePassword;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isManagedIdentityEnabled() {
        return this.managedIdentityEnabled;
    }

    public void setManagedIdentityEnabled(boolean managedIdentityEnabled) {
        this.managedIdentityEnabled = managedIdentityEnabled;
    }

    public String getTokenCredentialProviderClassName() {
        return this.tokenCredentialProviderClassName;
    }

    public void setTokenCredentialProviderClassName(String tokenCredentialProviderClassName) {
        this.tokenCredentialProviderClassName = tokenCredentialProviderClassName;
    }

    public String getTokenCredentialBeanName() {
        return this.tokenCredentialBeanName;
    }

    public void setTokenCredentialBeanName(String tokenCredentialBeanName) {
        this.tokenCredentialBeanName = tokenCredentialBeanName;
    }

    public String getAuthorityHost() {
        return this.authorityHost;
    }

    public void setAuthorityHost(String authorityHost) {
        this.authorityHost = authorityHost;
    }
}

