/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.util.configuration.Configuration;
import com.azure.core.util.configuration.ConfigurationManager;
import com.azure.identity.implementation.IdentityClient;
import reactor.core.publisher.Mono;

class AppServiceMSICredential {
    private final String msiEndpoint;
    private final String msiSecret;
    private final IdentityClient identityClient;
    private final String clientId;

    AppServiceMSICredential(String clientId, IdentityClient identityClient) {
        Configuration configuration = ConfigurationManager.getConfiguration();
        this.msiEndpoint = configuration.contains("MSI_ENDPOINT") ? configuration.get("MSI_ENDPOINT") : null;
        this.msiSecret = configuration.contains("MSI_SECRET") ? configuration.get("MSI_SECRET") : null;
        this.identityClient = identityClient;
        this.clientId = clientId;
    }

    public String msiEndpoint() {
        return this.msiEndpoint;
    }

    public String msiSecret() {
        return this.msiSecret;
    }

    public String clientId() {
        return this.clientId;
    }

    public Mono<AccessToken> authenticate(String[] scopes) {
        return this.identityClient.authenticateToManagedIdentityEndpoint(this.msiEndpoint, this.msiSecret, scopes);
    }
}

