/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.exception.ClientAuthenticationException;
import java.util.Deque;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ChainedTokenCredential
implements TokenCredential {
    private final Deque<TokenCredential> credentials;

    ChainedTokenCredential(Deque<TokenCredential> credentials) {
        this.credentials = credentials;
    }

    public Mono<AccessToken> getToken(String ... scopes) {
        return Flux.fromIterable(this.credentials).flatMap(p -> p.getToken(scopes).onErrorResume(t -> Mono.empty())).next().switchIfEmpty(Mono.error((Throwable)new ClientAuthenticationException("No credential can provide a token in the chain", null)));
    }
}

