/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.identity.credential.AadCredentialBuilderBase;
import com.azure.identity.credential.ClientCertificateCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.HashMap;
import java.util.Map;

public class ClientCertificateCredentialBuilder
extends AadCredentialBuilderBase<ClientCertificateCredentialBuilder> {
    private String tenantId;
    private String clientCertificate;
    private String clientCertificatePassword;

    public ClientCertificateCredentialBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public ClientCertificateCredentialBuilder pemCertificate(String certificatePath) {
        this.clientCertificate = certificatePath;
        return this;
    }

    public ClientCertificateCredentialBuilder pfxCertificate(String certificatePath, String clientCertificatePassword) {
        this.clientCertificate = certificatePath;
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    public ClientCertificateCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", ClientCertificateCredentialBuilder.this.clientId);
                this.put("tenantId", ClientCertificateCredentialBuilder.this.tenantId);
                this.put("clientCertificate", ClientCertificateCredentialBuilder.this.clientCertificate);
            }
        });
        return new ClientCertificateCredential(this.tenantId, this.clientId, this.clientCertificate, this.clientCertificatePassword, this.identityClientOptions);
    }
}

