/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalToken;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class InteractiveBrowserCredential
implements TokenCredential {
    private final int port;
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;

    InteractiveBrowserCredential(String clientId, int port, IdentityClientOptions identityClientOptions) {
        this.port = port;
        this.identityClient = new IdentityClientBuilder().tenantId("common").clientId(clientId).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
    }

    public Mono<AccessToken> getToken(String ... scopes) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithUserRefreshToken(scopes, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithBrowserInteraction(scopes, this.port))).map(msalToken -> {
            this.cachedToken.set((MsalToken)((Object)msalToken));
            return msalToken;
        });
    }
}

