/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.util.configuration.Configuration;
import com.azure.core.util.configuration.ConfigurationManager;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.msalextensions.PersistentTokenCacheAccessAspect;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import java.net.MalformedURLException;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

public class SharedTokenCacheCredential
implements TokenCredential {
    private final String username;
    private final String clientID;
    private final Configuration configuration = ConfigurationManager.getConfiguration().clone();
    private PublicClientApplication pubClient;

    SharedTokenCacheCredential(String username, String clientID, IdentityClientOptions identityClientOptions) {
        this.username = username == null ? (this.configuration.contains("AZURE_USERNAME") ? this.configuration.get("AZURE_USERNAME") : null) : username;
        this.clientID = clientID;
    }

    public Mono<AccessToken> getToken(String ... scopes) {
        if (this.pubClient == null) {
            PersistentTokenCacheAccessAspect accessAspect = new PersistentTokenCacheAccessAspect();
            this.pubClient = ((PublicClientApplication.Builder)PublicClientApplication.builder((String)this.clientID).setTokenCacheAccessAspect((ITokenCacheAccessAspect)accessAspect)).build();
        }
        IAccount requestedAccount = null;
        Collection accounts = (Collection)this.pubClient.getAccounts().join();
        Iterator iter = accounts.iterator();
        if (this.username == null && iter.hasNext()) {
            requestedAccount = (IAccount)iter.next();
        } else {
            while (iter.hasNext()) {
                IAccount account = (IAccount)iter.next();
                if (!account.username().equals(this.username)) continue;
                requestedAccount = account;
                break;
            }
        }
        if (requestedAccount == null) {
            return Mono.error((Throwable)new RuntimeException("Requested account was not found"));
        }
        SilentParameters params = SilentParameters.builder(new HashSet<String>(Arrays.asList(scopes)), (IAccount)requestedAccount).build();
        try {
            CompletableFuture future = this.pubClient.acquireTokenSilently(params);
            return Mono.fromFuture(() -> future).map(result -> new AccessToken(result.accessToken(), result.expiresOnDate().toInstant().atOffset(ZoneOffset.UTC)));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return Mono.error((Throwable)new RuntimeException("Token was not found"));
        }
    }
}

