/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.implementation.http.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public final class AuthorizationCodeListener {
    private final ClientLogger logger = new ClientLogger(AuthorizationCodeListener.class);
    private NanoHTTPD httpServer;
    private MonoProcessor<String> authorizationCodeEmitter;

    private AuthorizationCodeListener(NanoHTTPD httpServer, MonoProcessor<String> authorizationCodeEmitter) {
        this.httpServer = httpServer;
        this.authorizationCodeEmitter = authorizationCodeEmitter;
        try {
            this.httpServer.start();
        }
        catch (IOException e) {
            this.logger.error("Unable to start identity authorization code listener on port " + httpServer.getListeningPort(), new Object[]{e});
        }
    }

    public static Mono<AuthorizationCodeListener> create(int port) {
        final MonoProcessor monoProcessor = MonoProcessor.create();
        return Mono.just((Object)new NanoHTTPD(port){

            public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
                String uriWithQueryParams = session.getUri() + "?" + session.getQueryParameterString();
                monoProcessor.onNext((Object)AuthorizationCodeListener.getCodeFromUri(uriWithQueryParams));
                return 1.newFixedLengthResponse((String)"");
            }
        }).map(server -> new AuthorizationCodeListener((NanoHTTPD)server, (MonoProcessor<String>)monoProcessor));
    }

    public Mono<Void> dispose() {
        return Mono.fromRunnable(() -> {
            this.httpServer.closeAllConnections();
            this.httpServer.stop();
        });
    }

    public Mono<String> listen() {
        return this.authorizationCodeEmitter;
    }

    private static String getCodeFromUri(String uri) {
        UrlBuilder urlBuilder = UrlBuilder.parse((String)uri);
        for (String query : urlBuilder.query().keySet()) {
            if (!"code".equalsIgnoreCase(query)) continue;
            return (String)urlBuilder.query().get(query);
        }
        return null;
    }
}

