/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.credential.AadCredentialBuilderBase;
import com.azure.identity.credential.AuthorizationCodeCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationCodeCredentialBuilder
extends AadCredentialBuilderBase<AuthorizationCodeCredentialBuilder> {
    private final ClientLogger logger = new ClientLogger(AuthorizationCodeCredentialBuilder.class);
    private String authCode;
    private String redirectUri;

    public AuthorizationCodeCredentialBuilder authorizationCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public AuthorizationCodeCredentialBuilder redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public AuthorizationCodeCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", AuthorizationCodeCredentialBuilder.this.clientId);
                this.put("authorizationCode", AuthorizationCodeCredentialBuilder.this.authCode);
                this.put("redirectUri", AuthorizationCodeCredentialBuilder.this.redirectUri);
            }
        });
        try {
            return new AuthorizationCodeCredential(this.clientId, this.tenantId, this.authCode, new URI(this.redirectUri), this.identityClientOptions);
        }
        catch (URISyntaxException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }
}

