/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenRequest;
import com.azure.core.util.Configuration;
import com.azure.identity.implementation.IdentityClient;
import reactor.core.publisher.Mono;

class AppServiceMSICredential {
    private final String msiEndpoint;
    private final String msiSecret;
    private final IdentityClient identityClient;
    private final String clientId;

    AppServiceMSICredential(String clientId, IdentityClient identityClient) {
        Configuration configuration = Configuration.getGlobalConfiguration();
        this.msiEndpoint = configuration.get("MSI_ENDPOINT");
        this.msiSecret = configuration.get("MSI_SECRET");
        this.identityClient = identityClient;
        this.clientId = clientId;
    }

    public String getMsiEndpoint() {
        return this.msiEndpoint;
    }

    public String getMsiSecret() {
        return this.msiSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Mono<AccessToken> authenticate(TokenRequest request) {
        return this.identityClient.authenticateToManagedIdentityEndpoint(this.msiEndpoint, this.msiSecret, request);
    }
}

