/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.credential;

import com.azure.core.credentials.AccessToken;
import com.azure.core.credentials.TokenCredential;
import com.azure.core.credentials.TokenRequest;
import com.azure.identity.DeviceCodeChallenge;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalToken;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public class DeviceCodeCredential
implements TokenCredential {
    private final Consumer<DeviceCodeChallenge> deviceCodeChallengeConsumer;
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;

    DeviceCodeCredential(String clientId, String tenantId, Consumer<DeviceCodeChallenge> deviceCodeChallengeConsumer, IdentityClientOptions identityClientOptions) {
        this.deviceCodeChallengeConsumer = deviceCodeChallengeConsumer;
        if (tenantId == null) {
            tenantId = "common";
        }
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
    }

    public Mono<AccessToken> getToken(TokenRequest request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithUserRefreshToken(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithDeviceCode(request, this.deviceCodeChallengeConsumer))).map(msalToken -> {
            this.cachedToken.set((MsalToken)((Object)msalToken));
            return msalToken;
        });
    }
}

