/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.ClientCertificateCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ClientCertificateCredentialBuilder
extends AadCredentialBuilderBase<ClientCertificateCredentialBuilder> {
    private String clientCertificatePath;
    private InputStream clientCertificate;
    private String clientCertificatePassword;
    private final ClientLogger logger = new ClientLogger(ClientCertificateCredentialBuilder.class);

    public ClientCertificateCredentialBuilder pemCertificate(String certificatePath) {
        ValidationUtil.validateFilePath(this.getClass().getSimpleName(), certificatePath, "Pem Certificate Path");
        this.clientCertificatePath = certificatePath;
        return this;
    }

    public ClientCertificateCredentialBuilder pemCertificate(InputStream certificate) {
        this.clientCertificate = certificate;
        return this;
    }

    public ClientCertificateCredentialBuilder pfxCertificate(String certificatePath, String clientCertificatePassword) {
        ValidationUtil.validateFilePath(this.getClass().getSimpleName(), certificatePath, "Pfx Certificate Path");
        this.clientCertificatePath = certificatePath;
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    public ClientCertificateCredentialBuilder pfxCertificate(InputStream certificate, String clientCertificatePassword) {
        this.clientCertificate = certificate;
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    public ClientCertificateCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    public ClientCertificateCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    public ClientCertificateCredentialBuilder includeX5c(boolean includeX5c) {
        this.identityClientOptions.setIncludeX5c(includeX5c);
        return this;
    }

    public ClientCertificateCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", ClientCertificateCredentialBuilder.this.clientId);
                this.put("tenantId", ClientCertificateCredentialBuilder.this.tenantId);
                this.put("clientCertificate", ClientCertificateCredentialBuilder.this.clientCertificate == null ? ClientCertificateCredentialBuilder.this.clientCertificatePath : ClientCertificateCredentialBuilder.this.clientCertificate);
            }
        });
        if (this.clientCertificate != null && this.clientCertificatePath != null) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Both certificate input stream and certificate path are provided in ClientCertificateCredentialBuilder. Only one of them should be provided."));
        }
        return new ClientCertificateCredential(this.tenantId, this.clientId, this.clientCertificatePath, this.clientCertificate, this.clientCertificatePassword, this.identityClientOptions);
    }
}

