/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.concurrent.ExecutorService;

public class EnvironmentCredentialBuilder
extends CredentialBuilderBase<EnvironmentCredentialBuilder> {
    private String authorityHost;

    public EnvironmentCredentialBuilder authorityHost(String authorityHost) {
        ValidationUtil.validateAuthHost(this.getClass().getSimpleName(), authorityHost);
        this.authorityHost = authorityHost;
        return this;
    }

    public EnvironmentCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public EnvironmentCredentialBuilder configuration(Configuration configuration) {
        this.identityClientOptions.setConfiguration(configuration);
        return this;
    }

    public EnvironmentCredential build() {
        if (!CoreUtils.isNullOrEmpty((CharSequence)this.authorityHost)) {
            this.identityClientOptions.setAuthorityHost(this.authorityHost);
        }
        return new EnvironmentCredential(this.identityClientOptions);
    }
}

