/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.util;

import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.experimental.credential.TokenRequestContextExperimental;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClientOptions;

public final class IdentityUtil {
    private static final ClientLogger LOGGER = new ClientLogger(IdentityUtil.class);

    private IdentityUtil() {
    }

    public static String resolveTenantId(String currentTenantId, TokenRequestContext requestContext, IdentityClientOptions options) {
        if (!(requestContext instanceof TokenRequestContextExperimental)) {
            return currentTenantId;
        }
        TokenRequestContextExperimental experimental = (TokenRequestContextExperimental)requestContext;
        String contextTenantId = experimental.getTenantId();
        if (!options.isMultiTenantAuthenticationAllowed()) {
            if (contextTenantId != null && !currentTenantId.equals(contextTenantId) && !options.isLegacyTenantSelectionEnabled()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("The TenantId received from a challenge did not match the configured TenantId and AllowMultiTenantAuthentication is false.", null));
            }
            return CoreUtils.isNullOrEmpty((CharSequence)currentTenantId) ? contextTenantId : currentTenantId;
        }
        return CoreUtils.isNullOrEmpty((CharSequence)contextTenantId) ? currentTenantId : contextTenantId;
    }
}

