/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.ManagedIdentityServiceCredential;
import com.azure.identity.implementation.IdentityClient;
import reactor.core.publisher.Mono;

class AppServiceMsiCredential
extends ManagedIdentityServiceCredential {
    private final String identityEndpoint;
    private final String identityHeader;
    private final ClientLogger logger = new ClientLogger(AppServiceMsiCredential.class);

    AppServiceMsiCredential(String clientId, IdentityClient identityClient) {
        super(clientId, identityClient, "AZURE APP SERVICE MSI/IDENTITY ENDPOINT");
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.identityEndpoint = configuration.get("IDENTITY_ENDPOINT");
        this.identityHeader = configuration.get("IDENTITY_HEADER");
        if (this.identityEndpoint != null) {
            this.validateEndpointProtocol(this.identityEndpoint, "MSI", this.logger);
        }
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext request) {
        return this.identityClient.authenticateToManagedIdentityEndpoint(this.identityEndpoint, this.identityHeader, request);
    }
}

