/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzureApplicationCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.ManagedIdentityCredential;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;

class AzureApplicationCredentialBuilder
extends CredentialBuilderBase<AzureApplicationCredentialBuilder> {
    private String managedIdentityClientId;
    private String managedIdentityResouceId;
    private final ClientLogger logger = new ClientLogger(AzureApplicationCredentialBuilder.class);

    AzureApplicationCredentialBuilder() {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.managedIdentityClientId = configuration.get("AZURE_CLIENT_ID");
    }

    public AzureApplicationCredentialBuilder authorityHost(String authorityHost) {
        this.identityClientOptions.setAuthorityHost(authorityHost);
        return this;
    }

    public AzureApplicationCredentialBuilder managedIdentityClientId(String clientId) {
        this.managedIdentityClientId = clientId;
        return this;
    }

    public AzureApplicationCredentialBuilder managedIdentityResourceId(String resourceId) {
        this.managedIdentityResouceId = resourceId;
        return this;
    }

    public AzureApplicationCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public AzureApplicationCredential build() {
        if (this.managedIdentityClientId != null && this.managedIdentityResouceId != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Only one of managedIdentityClientId and managedIdentityResourceId can be specified."));
        }
        return new AzureApplicationCredential(this.getCredentialsChain());
    }

    private ArrayList<TokenCredential> getCredentialsChain() {
        ArrayList<TokenCredential> output = new ArrayList<TokenCredential>(2);
        output.add(new EnvironmentCredential(this.identityClientOptions));
        output.add(new ManagedIdentityCredential(this.managedIdentityClientId, this.managedIdentityResouceId, this.identityClientOptions));
        return output;
    }
}

