/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.ClientAssertionCredential;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.RegionalAuthority;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ClientAssertionCredentialBuilder
extends AadCredentialBuilderBase<ClientAssertionCredentialBuilder> {
    private Supplier<String> clientAssertionSupplier;
    private final ClientLogger logger = new ClientLogger(ClientAssertionCredentialBuilder.class);

    public ClientAssertionCredentialBuilder clientAssertion(Supplier<String> clientAssertionSupplier) {
        this.clientAssertionSupplier = clientAssertionSupplier;
        return this;
    }

    public ClientAssertionCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    ClientAssertionCredentialBuilder regionalAuthority(RegionalAuthority regionalAuthority) {
        this.identityClientOptions.setRegionalAuthority(regionalAuthority);
        return this;
    }

    public ClientAssertionCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", ClientAssertionCredentialBuilder.this.clientId);
                this.put("tenantId", ClientAssertionCredentialBuilder.this.tenantId);
                this.put("clientAssertion", ClientAssertionCredentialBuilder.this.clientAssertionSupplier);
            }
        });
        return new ClientAssertionCredential(this.clientId, this.tenantId, this.clientAssertionSupplier, this.identityClientOptions);
    }
}

