/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.AzureAuthorityHosts;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalAuthenticationAccount;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.LoggingUtil;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class UsernamePasswordCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(UsernamePasswordCredential.class);
    private final String username;
    private final String password;
    private final IdentityClient identityClient;
    private final String authorityHost;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;

    UsernamePasswordCredential(String clientId, String tenantId, String username, String password, IdentityClientOptions identityClientOptions) {
        Objects.requireNonNull(username, "'username' cannot be null.");
        Objects.requireNonNull(password, "'password' cannot be null.");
        this.username = username;
        this.password = password;
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
        this.authorityHost = identityClientOptions.getAuthorityHost();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithUsernamePassword(request, this.username, this.password))).map(this::updateCache).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }

    public Mono<AuthenticationRecord> authenticate(TokenRequestContext request) {
        return Mono.defer(() -> this.identityClient.authenticateWithUsernamePassword(request, this.username, this.password)).map(this::updateCache).map(msalToken -> this.cachedToken.get().getAuthenticationRecord());
    }

    public Mono<AuthenticationRecord> authenticate() {
        String defaultScope = AzureAuthorityHosts.getDefaultScope(this.authorityHost);
        if (defaultScope == null) {
            return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClient.getIdentityClientOptions(), new CredentialUnavailableException("Authenticating in this environment requires specifying a TokenRequestContext."))));
        }
        return this.authenticate(new TokenRequestContext().addScopes(new String[]{defaultScope}));
    }

    private AccessToken updateCache(MsalToken msalToken) {
        this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId()), msalToken.getAccount().getTenantProfiles()));
        return msalToken;
    }
}

