/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.UsernamePasswordCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.HashMap;
import java.util.Map;

public class UsernamePasswordCredentialBuilder
extends AadCredentialBuilderBase<UsernamePasswordCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(UsernamePasswordCredentialBuilder.class);
    private String username;
    private String password;

    public UsernamePasswordCredentialBuilder username(String username) {
        this.username = username;
        return this;
    }

    public UsernamePasswordCredentialBuilder password(String password) {
        this.password = password;
        return this;
    }

    public UsernamePasswordCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    UsernamePasswordCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    UsernamePasswordCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    public UsernamePasswordCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", UsernamePasswordCredentialBuilder.this.clientId);
                this.put("username", UsernamePasswordCredentialBuilder.this.username);
                this.put("password", UsernamePasswordCredentialBuilder.this.password);
            }
        }, LOGGER);
        return new UsernamePasswordCredential(this.clientId, this.tenantId, this.username, this.password, this.identityClientOptions);
    }
}

