/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;

public final class MSIToken
extends AccessToken {
    private static final ClientLogger LOGGER = new ClientLogger(MSIToken.class);
    private static final OffsetDateTime EPOCH = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("M/d/yyyy H:mm:ss XXX").withLocale(Locale.US);
    private static final DateTimeFormatter DTF_WINDOWS = DateTimeFormatter.ofPattern("M/d/yyyy h:mm:ss a XXX").withLocale(Locale.US);
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_on")
    private String expiresOn;
    @JsonProperty(value="expires_in")
    private String expiresIn;
    @JsonProperty(value="refresh_in")
    private String refreshIn;

    @JsonCreator
    public MSIToken(@JsonProperty(value="access_token") String token, @JsonProperty(value="expires_on") String expiresOn, @JsonProperty(value="expires_in") String expiresIn, @JsonProperty(value="refresh_in") String refreshIn) {
        super(token, EPOCH.plusSeconds(MSIToken.parseToEpochSeconds(expiresOn, expiresIn)));
        this.accessToken = token;
        this.expiresOn = expiresOn;
        this.expiresIn = expiresIn;
        this.refreshIn = refreshIn;
    }

    public String getToken() {
        return this.accessToken;
    }

    private static Long parseToEpochSeconds(String expiresOn, String expiresIn) {
        String dateToParse = CoreUtils.isNullOrEmpty((CharSequence)expiresOn) ? expiresIn : expiresOn;
        try {
            long seconds = Long.parseLong(dateToParse);
            if (!CoreUtils.isNullOrEmpty((CharSequence)expiresOn)) {
                return seconds;
            }
            return OffsetDateTime.now(ZoneOffset.UTC).plusSeconds(seconds).toEpochSecond();
        }
        catch (NumberFormatException e) {
            LOGGER.verbose(e.getMessage());
            try {
                return Instant.from(DTF.parse(dateToParse)).getEpochSecond();
            }
            catch (DateTimeParseException e2) {
                LOGGER.verbose(e2.getMessage());
                try {
                    return Instant.from(DTF_WINDOWS.parse(dateToParse)).getEpochSecond();
                }
                catch (DateTimeParseException e3) {
                    LOGGER.verbose(e3.getMessage());
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unable to parse date time " + dateToParse));
                }
            }
        }
    }

    long getRefreshAtEpochSeconds() {
        if (this.refreshIn != null) {
            return OffsetDateTime.now(ZoneOffset.UTC).plusSeconds(Long.parseLong(this.refreshIn)).toEpochSecond();
        }
        OffsetDateTime expiresAt = EPOCH.plusSeconds(MSIToken.parseToEpochSeconds(this.expiresOn, this.expiresIn));
        Duration duration = Duration.between(OffsetDateTime.now(ZoneOffset.UTC), expiresAt);
        if (duration.toHours() >= 2L) {
            long halfDuration = duration.getSeconds() / 2L;
            return expiresAt.minusSeconds(halfDuration).toEpochSecond();
        }
        return expiresAt.toEpochSecond();
    }
}

