/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzureDeveloperCliCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public class AzureDeveloperCliCredentialBuilder
extends CredentialBuilderBase<AzureDeveloperCliCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AzureDeveloperCliCredentialBuilder.class);
    private String tenantId;

    public AzureDeveloperCliCredentialBuilder tenantId(String tenantId) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        this.tenantId = tenantId;
        return this;
    }

    public AzureDeveloperCliCredentialBuilder azureDeveloperCliCredentialTimeout(Duration duration) {
        this.identityClientOptions.setDeveloperCredentialTimeout(duration);
        return this;
    }

    public AzureDeveloperCliCredential build() {
        return new AzureDeveloperCliCredential(this.tenantId, this.identityClientOptions);
    }

    public AzureDeveloperCliCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants)));
        return this;
    }

    public AzureDeveloperCliCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants));
        return this;
    }
}

