/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.ValidationUtil;
import reactor.core.publisher.Mono;

public class WorkloadIdentityCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadIdentityCredential.class);
    private final IdentityClient identityClient;

    WorkloadIdentityCredential(String tenantId, String clientId, String federatedTokenFilePath, IdentityClientOptions identityClientOptions) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        String tenantIdInput = CoreUtils.isNullOrEmpty((CharSequence)tenantId) ? configuration.get("AZURE_TENANT_ID") : tenantId;
        String federatedTokenFilePathInput = CoreUtils.isNullOrEmpty((CharSequence)federatedTokenFilePath) ? configuration.get("AZURE_FEDERATED_TOKEN_FILE") : federatedTokenFilePath;
        String clientIdInput = CoreUtils.isNullOrEmpty((CharSequence)clientId) ? configuration.get("AZURE_CLIENT_ID") : clientId;
        this.identityClient = !CoreUtils.isNullOrEmpty((CharSequence)tenantIdInput) && !CoreUtils.isNullOrEmpty((CharSequence)federatedTokenFilePathInput) && !CoreUtils.isNullOrEmpty((CharSequence)clientIdInput) && !CoreUtils.isNullOrEmpty((CharSequence)identityClientOptions.getAuthorityHost()) ? new IdentityClientBuilder().clientAssertionPath(federatedTokenFilePathInput).clientId(clientId).tenantId(tenantIdInput).identityClientOptions(identityClientOptions).build() : null;
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.identityClient == null) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. The workload options are not fully configured. See the troubleshooting guide for more information. https://aka.ms/azsdk/java/identity/workloadidentitycredential/troubleshoot"))));
        }
        return this.identityClient.authenticateWithExchangeToken(request);
    }

    String getClientId() {
        return this.identityClient.getClientId();
    }
}

