/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.EventHubsProducerInstrumentation;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.implementation.EventHubConnectionProcessor;
import com.azure.messaging.eventhubs.implementation.EventHubManagementNode;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsConsumerInstrumentation;
import java.io.Closeable;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

class EventHubAsyncClient
implements Closeable {
    private static final ClientLogger LOGGER = new ClientLogger(EventHubAsyncClient.class);
    private final MessageSerializer messageSerializer;
    private final EventHubConnectionProcessor connectionProcessor;
    private final Scheduler scheduler;
    private final boolean isSharedConnection;
    private final Runnable onClientClose;
    private final String identifier;
    private final Tracer tracer;
    private final Meter meter;

    EventHubAsyncClient(EventHubConnectionProcessor connectionProcessor, MessageSerializer messageSerializer, Scheduler scheduler, boolean isSharedConnection, Runnable onClientClose, String identifier, Meter meter, Tracer tracer) {
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.connectionProcessor = Objects.requireNonNull(connectionProcessor, "'connectionProcessor' cannot be null.");
        this.scheduler = Objects.requireNonNull(scheduler, "'scheduler' cannot be null");
        this.onClientClose = Objects.requireNonNull(onClientClose, "'onClientClose' cannot be null.");
        this.isSharedConnection = isSharedConnection;
        this.identifier = identifier;
        this.tracer = tracer;
        this.meter = meter;
    }

    String getFullyQualifiedNamespace() {
        return this.connectionProcessor.getFullyQualifiedNamespace();
    }

    String getEventHubName() {
        return this.connectionProcessor.getEventHubName();
    }

    Mono<EventHubProperties> getProperties() {
        return this.connectionProcessor.getManagementNodeWithRetries().flatMap(EventHubManagementNode::getEventHubProperties);
    }

    Flux<String> getPartitionIds() {
        return this.getProperties().flatMapMany(properties -> Flux.fromIterable(properties.getPartitionIds()));
    }

    Mono<PartitionProperties> getPartitionProperties(String partitionId) {
        return this.connectionProcessor.getManagementNodeWithRetries().flatMap(node -> node.getPartitionProperties(partitionId));
    }

    EventHubProducerAsyncClient createProducer() {
        EventHubsProducerInstrumentation instrumentation = new EventHubsProducerInstrumentation(this.tracer, this.meter, this.connectionProcessor.getFullyQualifiedNamespace(), this.connectionProcessor.getEventHubName());
        return new EventHubProducerAsyncClient(this.connectionProcessor.getFullyQualifiedNamespace(), this.getEventHubName(), this.connectionProcessor, this.connectionProcessor.getRetryOptions(), this.messageSerializer, this.scheduler, this.isSharedConnection, this.onClientClose, this.identifier, instrumentation);
    }

    EventHubConsumerAsyncClient createConsumer(String consumerGroup, int prefetchCount, boolean isSync) {
        Objects.requireNonNull(consumerGroup, "'consumerGroup' cannot be null.");
        if (consumerGroup.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'consumerGroup' cannot be an empty string."));
        }
        EventHubsConsumerInstrumentation instrumentation = new EventHubsConsumerInstrumentation(this.tracer, this.meter, this.connectionProcessor.getFullyQualifiedNamespace(), this.connectionProcessor.getEventHubName(), consumerGroup, isSync);
        return new EventHubConsumerAsyncClient(this.connectionProcessor.getFullyQualifiedNamespace(), this.getEventHubName(), this.connectionProcessor, this.messageSerializer, consumerGroup, prefetchCount, this.isSharedConnection, this.onClientClose, this.identifier, instrumentation);
    }

    @Override
    public void close() {
        this.connectionProcessor.dispose();
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

