/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation.instrumentation;

import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracingLink;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.PartitionEvent;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class EventHubsTracer {
    private static final AutoCloseable NOOP_AUTOCLOSEABLE = () -> {};
    public static final String REACTOR_PARENT_TRACE_CONTEXT_KEY = "otel-context-key";
    public static final String TRACEPARENT_KEY = "traceparent";
    public static final String DIAGNOSTIC_ID_KEY = "Diagnostic-Id";
    public static final String MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME = "messaging.eventhubs.message.enqueued_time";
    public static final String MESSAGING_BATCH_SIZE_ATTRIBUTE_NAME = "messaging.batch.message_count";
    private static final String MESSAGING_SYSTEM_ATTRIBUTE_NAME = "messaging.system";
    private static final String MESSAGING_OPERATION_ATTRIBUTE_NAME = "messaging.operation";
    private static final TracingLink DUMMY_LINK = new TracingLink(com.azure.core.util.Context.NONE);
    private static final ClientLogger LOGGER = new ClientLogger(EventHubsTracer.class);
    private static final boolean IS_TRACING_DISABLED = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED", (Object)false);
    protected final Tracer tracer;
    private final String fullyQualifiedName;
    private final String entityName;

    public EventHubsTracer(Tracer tracer, String fullyQualifiedName, String entityName) {
        this.tracer = IS_TRACING_DISABLED ? null : tracer;
        this.fullyQualifiedName = Objects.requireNonNull(fullyQualifiedName, "'fullyQualifiedName' cannot be null");
        this.entityName = Objects.requireNonNull(entityName, "'entityPath' cannot be null");
    }

    public boolean isEnabled() {
        return this.tracer != null && this.tracer.isEnabled();
    }

    public com.azure.core.util.Context startSpan(String spanName, StartSpanOptions startOptions, com.azure.core.util.Context context) {
        return this.isEnabled() ? this.tracer.start(spanName, startOptions, context) : context;
    }

    public <T> Mono<T> traceMono(Mono<T> publisher, String spanName) {
        if (this.isEnabled()) {
            return publisher.doOnEach(signal -> {
                if (signal.isOnComplete() || signal.isOnError()) {
                    com.azure.core.util.Context span = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)com.azure.core.util.Context.NONE);
                    this.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite((ContextView)Context.of((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.tracer.start(spanName, this.createStartOption(SpanKind.CLIENT, null), com.azure.core.util.Context.NONE)));
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSpan(Throwable throwable, com.azure.core.util.Context span, AutoCloseable scope) {
        if (this.isEnabled()) {
            String errorCondition;
            block6: {
                AmqpException exception;
                errorCondition = null;
                if (throwable instanceof AmqpException && (exception = (AmqpException)throwable).getErrorCondition() != null) {
                    errorCondition = exception.getErrorCondition().getErrorCondition();
                }
                try {
                    if (scope == null) break block6;
                    scope.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.warning("Can't close scope", new Object[]{e});
                    }
                    catch (Throwable throwable2) {
                        this.tracer.end(errorCondition, throwable, span);
                        throw throwable2;
                    }
                    this.tracer.end(errorCondition, throwable, span);
                }
            }
            this.tracer.end(errorCondition, throwable, span);
        }
    }

    public void reportMessageSpan(EventData eventData, com.azure.core.util.Context eventContext) {
        if (!this.isEnabled() || eventContext == null || eventContext.getData((Object)"span-context").isPresent()) {
            return;
        }
        String traceparent = EventHubsTracer.getTraceparent(eventData.getProperties());
        if (traceparent != null) {
            return;
        }
        StartSpanOptions startOptions = this.createStartOption(SpanKind.PRODUCER, null);
        com.azure.core.util.Context eventSpanContext = this.tracer.start("EventHubs.message", startOptions, eventContext);
        RuntimeException exception = null;
        String error = null;
        if (EventHubsTracer.canModifyApplicationProperties(eventData.getProperties())) {
            try {
                this.tracer.injectContext((key, value) -> {
                    eventData.getProperties().put((String)key, value);
                    if (TRACEPARENT_KEY.equals(key)) {
                        eventData.getProperties().put(DIAGNOSTIC_ID_KEY, value);
                    }
                }, eventSpanContext);
            }
            catch (RuntimeException ex) {
                LOGGER.warning("Failed to inject context into EventData", new Object[]{ex});
                exception = ex;
            }
        } else {
            error = "failed to inject context into EventData";
        }
        this.tracer.end(error, exception, eventSpanContext);
        Optional spanContext = eventSpanContext.getData((Object)"span-context");
        if (spanContext.isPresent()) {
            eventData.addContext("span-context", spanContext.get());
        }
    }

    private static boolean canModifyApplicationProperties(Map<String, Object> applicationProperties) {
        return applicationProperties != null && !applicationProperties.getClass().getSimpleName().equals("UnmodifiableMap");
    }

    public TracingLink createLink(Map<String, Object> applicationProperties, Instant enqueuedTime, com.azure.core.util.Context eventContext) {
        if (!this.tracer.isEnabled() || applicationProperties == null) {
            return DUMMY_LINK;
        }
        com.azure.core.util.Context link = com.azure.core.util.Context.NONE;
        Optional linkContext = eventContext.getData((Object)"span-context");
        if (linkContext.isPresent()) {
            if (linkContext.get() instanceof com.azure.core.util.Context) {
                link = (com.azure.core.util.Context)linkContext.get();
            } else {
                LOGGER.verbose("Unexpected type under 'span-context' key - {}", new Object[]{linkContext.get().getClass()});
            }
        } else {
            link = this.extractContext(applicationProperties);
        }
        Map<String, Long> linkAttributes = null;
        if (enqueuedTime != null) {
            linkAttributes = Collections.singletonMap(MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME, enqueuedTime.atOffset(ZoneOffset.UTC).toEpochSecond());
        }
        return new TracingLink(link, linkAttributes);
    }

    public com.azure.core.util.Context extractContext(Map<String, Object> applicationProperties) {
        if (this.tracer.isEnabled() && applicationProperties != null) {
            return this.tracer.extractContext(key -> {
                if (TRACEPARENT_KEY.equals(key)) {
                    return EventHubsTracer.getTraceparent(applicationProperties);
                }
                Object value = applicationProperties.get(key);
                if (value != null) {
                    return value.toString();
                }
                return null;
            });
        }
        return com.azure.core.util.Context.NONE;
    }

    public AutoCloseable makeSpanCurrent(com.azure.core.util.Context context) {
        return this.isEnabled() ? this.tracer.makeSpanCurrent(context) : NOOP_AUTOCLOSEABLE;
    }

    public com.azure.core.util.Context startProcessSpan(String name, EventData event, com.azure.core.util.Context parent) {
        if (this.isEnabled() && event != null) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CONSUMER, OperationName.PROCESS).setRemoteParent(this.extractContext(event.getProperties()));
            Instant enqueuedTime = event.getEnqueuedTime();
            if (enqueuedTime != null) {
                startOptions.setAttribute(MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME, (Object)enqueuedTime.atOffset(ZoneOffset.UTC).toEpochSecond());
            }
            return this.tracer.start(name, startOptions, parent);
        }
        return parent;
    }

    public com.azure.core.util.Context startProcessSpan(String name, List<EventData> events, com.azure.core.util.Context parent) {
        if (this.isEnabled() && events != null) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CONSUMER, OperationName.PROCESS);
            startOptions.setAttribute(MESSAGING_BATCH_SIZE_ATTRIBUTE_NAME, (Object)events.size());
            for (EventData event : events) {
                startOptions.addLink(this.createLink(event.getProperties(), event.getEnqueuedTime(), com.azure.core.util.Context.NONE));
            }
            return this.tracer.start(name, startOptions, parent);
        }
        return parent;
    }

    public Flux<PartitionEvent> reportSyncReceiveSpan(String name, Instant startTime, Flux<PartitionEvent> events, com.azure.core.util.Context parent) {
        if (this.isEnabled() && events != null) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, OperationName.RECEIVE).setStartTimestamp(startTime);
            return events.doOnEach(signal -> {
                if (signal.hasValue()) {
                    EventData data = ((PartitionEvent)signal.get()).getData();
                    if (data != null) {
                        startOptions.addLink(this.createLink(data.getProperties(), data.getEnqueuedTime(), com.azure.core.util.Context.NONE));
                    }
                } else if (signal.isOnComplete() || signal.isOnError()) {
                    int batchSize = startOptions.getLinks() == null ? 0 : startOptions.getLinks().size();
                    startOptions.setAttribute(MESSAGING_BATCH_SIZE_ATTRIBUTE_NAME, (Object)batchSize);
                    com.azure.core.util.Context span = this.tracer.start(name, startOptions, parent);
                    this.tracer.end(null, signal.getThrowable(), span);
                }
            });
        }
        return events;
    }

    private static String getTraceparent(Map<String, Object> applicationProperties) {
        Object diagnosticId = applicationProperties.get(DIAGNOSTIC_ID_KEY);
        if (diagnosticId == null) {
            diagnosticId = applicationProperties.get(TRACEPARENT_KEY);
        }
        return diagnosticId == null ? null : diagnosticId.toString();
    }

    public StartSpanOptions createStartOption(SpanKind kind, OperationName operationName) {
        StartSpanOptions startOptions = new StartSpanOptions(kind).setAttribute(MESSAGING_SYSTEM_ATTRIBUTE_NAME, (Object)"eventhubs").setAttribute("entity-path", (Object)this.entityName).setAttribute("hostname", (Object)this.fullyQualifiedName);
        if (operationName != null) {
            startOptions.setAttribute(MESSAGING_OPERATION_ATTRIBUTE_NAME, (Object)operationName.toString());
        }
        return startOptions;
    }

    public static enum OperationName {
        PUBLISH("publish"),
        RECEIVE("receive"),
        PROCESS("process");

        private final String operationName;

        private OperationName(String operationName) {
            this.operationName = operationName;
        }

        public String toString() {
            return this.operationName;
        }
    }
}

