/*
 * Decompiled with CFR 0.152.
 */
package com.azure.servicebus.jms;

import com.azure.servicebus.jms.ServiceBusJmsQueue;
import com.azure.servicebus.jms.ServiceBusJmsTopic;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;

class ServiceBusJmsContext
implements JMSContext {
    private final JMSContext innerJmsContext;

    ServiceBusJmsContext(JMSContext jmsContext) {
        this.innerJmsContext = jmsContext;
    }

    public void acknowledge() {
        this.innerJmsContext.acknowledge();
    }

    public void close() {
        this.innerJmsContext.close();
    }

    public void commit() {
        this.innerJmsContext.commit();
    }

    public QueueBrowser createBrowser(Queue queue) {
        return this.innerJmsContext.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return this.innerJmsContext.createBrowser(queue, messageSelector);
    }

    public BytesMessage createBytesMessage() {
        return this.innerJmsContext.createBytesMessage();
    }

    public JMSConsumer createConsumer(Destination destination) {
        return this.innerJmsContext.createConsumer(destination);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        return this.innerJmsContext.createConsumer(destination, messageSelector);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        return this.innerJmsContext.createConsumer(destination, messageSelector, noLocal);
    }

    public JMSContext createContext(int sessionMode) {
        return this.innerJmsContext.createContext(sessionMode);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return this.innerJmsContext.createDurableConsumer(topic, name);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        return this.innerJmsContext.createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public MapMessage createMapMessage() {
        return this.innerJmsContext.createMapMessage();
    }

    public Message createMessage() {
        return this.innerJmsContext.createMessage();
    }

    public ObjectMessage createObjectMessage() {
        return this.innerJmsContext.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return this.innerJmsContext.createObjectMessage(object);
    }

    public JMSProducer createProducer() {
        return this.innerJmsContext.createProducer();
    }

    public Queue createQueue(String queueName) {
        Queue innerQueue = this.innerJmsContext.createQueue(queueName);
        return new ServiceBusJmsQueue(innerQueue);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return this.innerJmsContext.createSharedConsumer(topic, sharedSubscriptionName);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        return this.innerJmsContext.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return this.innerJmsContext.createSharedDurableConsumer(topic, name);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        return this.innerJmsContext.createSharedDurableConsumer(topic, name, messageSelector);
    }

    public StreamMessage createStreamMessage() {
        return this.innerJmsContext.createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() {
        return this.innerJmsContext.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() {
        return this.innerJmsContext.createTemporaryTopic();
    }

    public TextMessage createTextMessage() {
        return this.innerJmsContext.createTextMessage();
    }

    public TextMessage createTextMessage(String text) {
        return this.innerJmsContext.createTextMessage(text);
    }

    public Topic createTopic(String topicName) {
        Topic innerTopic = this.innerJmsContext.createTopic(topicName);
        return new ServiceBusJmsTopic(innerTopic);
    }

    public boolean getAutoStart() {
        return this.innerJmsContext.getAutoStart();
    }

    public String getClientID() {
        return this.innerJmsContext.getClientID();
    }

    public ExceptionListener getExceptionListener() {
        return this.innerJmsContext.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() {
        return this.innerJmsContext.getMetaData();
    }

    public int getSessionMode() {
        return this.innerJmsContext.getSessionMode();
    }

    public boolean getTransacted() {
        return this.innerJmsContext.getTransacted();
    }

    public void recover() {
        this.innerJmsContext.recover();
    }

    public void rollback() {
        this.innerJmsContext.rollback();
    }

    public void setAutoStart(boolean autoStart) {
        this.innerJmsContext.setAutoStart(autoStart);
    }

    public void setClientID(String clientID) {
        this.innerJmsContext.setClientID(clientID);
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.innerJmsContext.setExceptionListener(listener);
    }

    public void start() {
        this.innerJmsContext.start();
    }

    public void stop() {
        this.innerJmsContext.stop();
    }

    public void unsubscribe(String name) {
        this.innerJmsContext.unsubscribe(name);
    }
}

