/*
 * Decompiled with CFR 0.152.
 */
package com.azure.servicebus.jms;

import com.azure.servicebus.jms.ServiceBusJmsQueue;
import com.azure.servicebus.jms.ServiceBusJmsTopic;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;

class ServiceBusJmsSession
implements Session {
    private final Session innerSession;

    ServiceBusJmsSession(Session innerSession) {
        this.innerSession = innerSession;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.innerSession.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.innerSession.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.innerSession.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.innerSession.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.innerSession.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.innerSession.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.innerSession.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.innerSession.createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.innerSession.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.innerSession.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.innerSession.commit();
    }

    public void rollback() throws JMSException {
        this.innerSession.rollback();
    }

    public void close() throws JMSException {
        this.innerSession.close();
    }

    public void recover() throws JMSException {
        this.innerSession.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.innerSession.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.innerSession.setMessageListener(listener);
    }

    public void run() {
        this.innerSession.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.innerSession.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.innerSession.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.innerSession.createConsumer(destination, messageSelector);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        return this.innerSession.createConsumer(destination, messageSelector, NoLocal);
    }

    public Queue createQueue(String queueName) throws JMSException {
        Queue innerQueue = this.innerSession.createQueue(queueName);
        return new ServiceBusJmsQueue(innerQueue);
    }

    public Topic createTopic(String topicName) throws JMSException {
        Topic innerTopic = this.innerSession.createTopic(topicName);
        return new ServiceBusJmsTopic(innerTopic);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.innerSession.createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.innerSession.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.innerSession.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.innerSession.createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.innerSession.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.innerSession.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.innerSession.unsubscribe(name);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.innerSession.createSharedConsumer(topic, sharedSubscriptionName);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        return this.innerSession.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.innerSession.createDurableConsumer(topic, name);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.innerSession.createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.innerSession.createSharedDurableConsumer(topic, name);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        return this.innerSession.createSharedDurableConsumer(topic, name, messageSelector);
    }
}

