/*
 * Decompiled with CFR 0.152.
 */
package com.azure.servicebus.jms;

import com.azure.servicebus.jms.ConnectionStringBuilder;
import com.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import com.azure.servicebus.jms.ServiceBusJmsTopicConnection;
import jakarta.jms.JMSException;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;

public class ServiceBusJmsTopicConnectionFactory
extends ServiceBusJmsConnectionFactory
implements TopicConnectionFactory {
    public ServiceBusJmsTopicConnectionFactory(String connectionString, ServiceBusJmsConnectionFactorySettings settings) {
        super(connectionString, settings);
    }

    public ServiceBusJmsTopicConnectionFactory(ConnectionStringBuilder connectionStringBuilder, ServiceBusJmsConnectionFactorySettings settings) {
        super(connectionStringBuilder, settings);
    }

    public ServiceBusJmsTopicConnectionFactory(String sasKeyName, String sasKey, String host, ServiceBusJmsConnectionFactorySettings settings) {
        super(sasKeyName, sasKey, host, settings);
    }

    @Override
    public TopicConnection createTopicConnection() throws JMSException {
        TopicConnection innerTopicConnection = super.createTopicConnection();
        return new ServiceBusJmsTopicConnection(innerTopicConnection);
    }

    @Override
    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        TopicConnection innerTopicConnection = super.createTopicConnection(userName, password);
        return new ServiceBusJmsTopicConnection(innerTopicConnection);
    }
}

