/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.BlockBlobCommitBlockListHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobPutBlobFromUrlHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobUploadHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.BlockLookupList;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.options.BlobUploadFromUrlOptions;
import com.azure.storage.blob.options.BlockBlobCommitBlockListOptions;
import com.azure.storage.blob.options.BlockBlobListBlocksOptions;
import com.azure.storage.blob.options.BlockBlobSimpleUploadOptions;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class BlockBlobAsyncClient
extends BlobAsyncClientBase {
    private final ClientLogger logger = new ClientLogger(BlockBlobAsyncClient.class);
    @Deprecated
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final long MAX_UPLOAD_BLOB_BYTES_LONG = 5242880000L;
    @Deprecated
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final long MAX_STAGE_BLOCK_BYTES_LONG = 0xFA000000L;
    public static final int MAX_BLOCKS = 50000;

    BlockBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
    }

    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, long length) {
        try {
            return this.upload(data, length, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, long length, boolean overwrite) {
        try {
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            if (!overwrite) {
                blobRequestConditions.setIfNoneMatch("*");
            }
            return this.uploadWithResponse(data, length, null, null, null, null, blobRequestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlockBlobItem>> uploadWithResponse(Flux<ByteBuffer> data, long length, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, byte[] contentMd5, BlobRequestConditions requestConditions) {
        return this.uploadWithResponse(new BlockBlobSimpleUploadOptions(data, length).setHeaders(headers).setMetadata(metadata).setTier(tier).setContentMd5(contentMd5).setRequestConditions(requestConditions));
    }

    public Mono<Response<BlockBlobItem>> uploadWithResponse(BlockBlobSimpleUploadOptions options) {
        try {
            return FluxUtil.withContext(context -> this.uploadWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlockBlobItem>> uploadWithResponse(BlockBlobSimpleUploadOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Flux data = options.getDataFlux() == null ? Utility.convertStreamToByteBuffer((InputStream)options.getDataStream(), (long)options.getLength(), (int)0x400000, (boolean)true).subscribeOn(Schedulers.elastic()) : options.getDataFlux();
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blockBlobs().uploadWithRestResponseAsync(null, null, (Flux<ByteBuffer>)data, options.getLength(), null, options.getContentMd5(), options.getMetadata(), requestConditions.getLeaseId(), options.getTier(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.tagsToString(options.getTags()), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            BlockBlobUploadHeaders hd = (BlockBlobUploadHeaders)rb.getDeserializedHeaders();
            BlockBlobItem item = new BlockBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), hd.getEncryptionScope(), hd.getVersionId());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<BlockBlobItem> uploadFromUrl(String sourceUrl) {
        try {
            return this.uploadFromUrl(sourceUrl, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<BlockBlobItem> uploadFromUrl(String sourceUrl, boolean overwrite) {
        try {
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            if (!overwrite) {
                blobRequestConditions.setIfNoneMatch("*");
            }
            return this.uploadFromUrlWithResponse(new BlobUploadFromUrlOptions(sourceUrl).setDestinationRequestConditions(blobRequestConditions)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlockBlobItem>> uploadFromUrlWithResponse(BlobUploadFromUrlOptions options) {
        try {
            return FluxUtil.withContext(context -> this.uploadFromUrlWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlockBlobItem>> uploadFromUrlWithResponse(BlobUploadFromUrlOptions options, Context context) {
        URL url;
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new BlobRequestConditions() : options.getDestinationRequestConditions();
        BlobRequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new BlobRequestConditions() : options.getSourceRequestConditions();
        context = context == null ? Context.NONE : context;
        try {
            url = new URL(options.getSourceUrl());
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url."));
        }
        return this.azureBlobStorage.blockBlobs().putBlobFromUrlWithRestResponseAsync(null, null, 0L, url, null, null, null, destinationRequestConditions.getLeaseId(), options.getTier(), destinationRequestConditions.getIfModifiedSince(), destinationRequestConditions.getIfUnmodifiedSince(), destinationRequestConditions.getIfMatch(), destinationRequestConditions.getIfNoneMatch(), destinationRequestConditions.getTagsConditions(), sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), sourceRequestConditions.getTagsConditions(), null, options.getContentMd5(), this.tagsToString(options.getTags()), options.isCopySourceBlobProperties(), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            BlockBlobPutBlobFromUrlHeaders hd = (BlockBlobPutBlobFromUrlHeaders)rb.getDeserializedHeaders();
            BlockBlobItem item = new BlockBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), hd.getEncryptionScope(), hd.getVersionId());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<Void> stageBlock(String base64BlockId, Flux<ByteBuffer> data, long length) {
        try {
            return this.stageBlockWithResponse(base64BlockId, data, length, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> stageBlockWithResponse(String base64BlockId, Flux<ByteBuffer> data, long length, byte[] contentMd5, String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.stageBlockWithResponse(base64BlockId, data, length, contentMd5, leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> stageBlockWithResponse(String base64BlockId, Flux<ByteBuffer> data, long length, byte[] contentMd5, String leaseId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blockBlobs().stageBlockWithRestResponseAsync(null, null, base64BlockId, length, data, contentMd5, null, null, leaseId, null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> stageBlockFromUrl(String base64BlockId, String sourceUrl, BlobRange sourceRange) {
        try {
            return this.stageBlockFromUrlWithResponse(base64BlockId, sourceUrl, sourceRange, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> stageBlockFromUrlWithResponse(String base64BlockId, String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, String leaseId, BlobRequestConditions sourceRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.stageBlockFromUrlWithResponse(base64BlockId, sourceUrl, sourceRange, sourceContentMd5, leaseId, sourceRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> stageBlockFromUrlWithResponse(String base64BlockId, String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, String leaseId, BlobRequestConditions sourceRequestConditions, Context context) {
        URL url;
        sourceRange = sourceRange == null ? new BlobRange(0L) : sourceRange;
        sourceRequestConditions = sourceRequestConditions == null ? new BlobRequestConditions() : sourceRequestConditions;
        try {
            url = new URL(sourceUrl);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url."));
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blockBlobs().stageBlockFromURLWithRestResponseAsync(null, null, base64BlockId, 0L, url, sourceRange.toHeaderValue(), sourceContentMd5, null, null, leaseId, sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<BlockList> listBlocks(BlockListType listType) {
        try {
            return this.listBlocksWithResponse(listType, null).map(Response::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlockList>> listBlocksWithResponse(BlockListType listType, String leaseId) {
        try {
            return this.listBlocksWithResponse(new BlockBlobListBlocksOptions(listType).setLeaseId(leaseId));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlockList>> listBlocksWithResponse(BlockBlobListBlocksOptions options) {
        try {
            return FluxUtil.withContext(context -> this.listBlocksWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlockList>> listBlocksWithResponse(BlockBlobListBlocksOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        return this.azureBlobStorage.blockBlobs().getBlockListWithRestResponseAsync(null, null, options.getType(), this.getSnapshotId(), null, options.getLeaseId(), options.getIfTagsMatch(), null, context).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    public Mono<BlockBlobItem> commitBlockList(List<String> base64BlockIds) {
        try {
            return this.commitBlockList(base64BlockIds, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<BlockBlobItem> commitBlockList(List<String> base64BlockIds, boolean overwrite) {
        try {
            BlobRequestConditions requestConditions = null;
            if (!overwrite) {
                requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
            }
            return this.commitBlockListWithResponse(base64BlockIds, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlockBlobItem>> commitBlockListWithResponse(List<String> base64BlockIds, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.commitBlockListWithResponse(new BlockBlobCommitBlockListOptions(base64BlockIds).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
    }

    public Mono<Response<BlockBlobItem>> commitBlockListWithResponse(BlockBlobCommitBlockListOptions options) {
        try {
            return FluxUtil.withContext(context -> this.commitBlockListWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlockBlobItem>> commitBlockListWithResponse(BlockBlobCommitBlockListOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blockBlobs().commitBlockListWithRestResponseAsync(null, null, new BlockLookupList().setLatest(options.getBase64BlockIds()), null, null, null, options.getMetadata(), requestConditions.getLeaseId(), options.getTier(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.tagsToString(options.getTags()), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            BlockBlobCommitBlockListHeaders hd = (BlockBlobCommitBlockListHeaders)rb.getDeserializedHeaders();
            BlockBlobItem item = new BlockBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), hd.getEncryptionScope(), hd.getVersionId());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }
}

