/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageList;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.options.PageBlobCopyIncrementalOptions;
import com.azure.storage.blob.options.PageBlobCreateOptions;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.PageBlobAsyncClient;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class PageBlobClient
extends BlobClientBase {
    private final PageBlobAsyncClient pageBlobAsyncClient;
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;

    PageBlobClient(PageBlobAsyncClient pageBlobAsyncClient) {
        super(pageBlobAsyncClient);
        this.pageBlobAsyncClient = pageBlobAsyncClient;
    }

    public BlobOutputStream getBlobOutputStream(PageRange pageRange) {
        return this.getBlobOutputStream(pageRange, null);
    }

    public BlobOutputStream getBlobOutputStream(PageRange pageRange, BlobRequestConditions requestConditions) {
        return BlobOutputStream.pageBlobOutputStream(this.pageBlobAsyncClient, pageRange, requestConditions);
    }

    public PageBlobItem create(long size) {
        return this.create(size, false);
    }

    public PageBlobItem create(long size, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return (PageBlobItem)this.createWithResponse(size, null, null, null, blobRequestConditions, null, Context.NONE).getValue();
    }

    public Response<PageBlobItem> createWithResponse(long size, Long sequenceNumber, BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return this.createWithResponse(new PageBlobCreateOptions(size).setSequenceNumber(sequenceNumber).setHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions), timeout, context);
    }

    public Response<PageBlobItem> createWithResponse(PageBlobCreateOptions options, Duration timeout, Context context) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.createWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public PageBlobItem uploadPages(PageRange pageRange, InputStream body) {
        return (PageBlobItem)this.uploadPagesWithResponse(pageRange, body, null, null, null, Context.NONE).getValue();
    }

    public Response<PageBlobItem> uploadPagesWithResponse(PageRange pageRange, InputStream body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions, Duration timeout, Context context) {
        Objects.requireNonNull(body, "'body' cannot be null.");
        long length = pageRange.getEnd() - pageRange.getStart() + 1L;
        Flux fbb = Utility.convertStreamToByteBuffer((InputStream)body, (long)length, (int)512, (boolean)true);
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.uploadPagesWithResponse(pageRange, (Flux<ByteBuffer>)fbb.subscribeOn(Schedulers.elastic()), contentMd5, pageBlobRequestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public PageBlobItem uploadPagesFromUrl(PageRange range, String sourceUrl, Long sourceOffset) {
        return (PageBlobItem)this.uploadPagesFromUrlWithResponse(range, sourceUrl, sourceOffset, null, null, null, null, Context.NONE).getValue();
    }

    public Response<PageBlobItem> uploadPagesFromUrlWithResponse(PageRange range, String sourceUrl, Long sourceOffset, byte[] sourceContentMd5, PageBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions, Duration timeout, Context context) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.uploadPagesFromUrlWithResponse(range, sourceUrl, sourceOffset, sourceContentMd5, destRequestConditions, sourceRequestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public PageBlobItem clearPages(PageRange pageRange) {
        return (PageBlobItem)this.clearPagesWithResponse(pageRange, null, null, Context.NONE).getValue();
    }

    public Response<PageBlobItem> clearPagesWithResponse(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions, Duration timeout, Context context) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.clearPagesWithResponse(pageRange, pageBlobRequestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public PageList getPageRanges(BlobRange blobRange) {
        return (PageList)this.getPageRangesWithResponse(blobRange, null, null, Context.NONE).getValue();
    }

    public Response<PageList> getPageRangesWithResponse(BlobRange blobRange, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.pageBlobAsyncClient.getPageRangesWithResponse(blobRange, requestConditions, context), (Duration)timeout);
    }

    public PageList getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return (PageList)this.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null, null, Context.NONE).getValue();
    }

    public Response<PageList> getPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshot, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.pageBlobAsyncClient.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null, requestConditions, context), (Duration)timeout);
    }

    public PageList getManagedDiskPageRangesDiff(BlobRange blobRange, String prevSnapshotUrl) {
        return (PageList)this.getManagedDiskPageRangesDiffWithResponse(blobRange, prevSnapshotUrl, null, null, Context.NONE).getValue();
    }

    public Response<PageList> getManagedDiskPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshotUrl, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.pageBlobAsyncClient.getPageRangesDiffWithResponse(blobRange, null, prevSnapshotUrl, requestConditions, context), (Duration)timeout);
    }

    public PageBlobItem resize(long size) {
        return (PageBlobItem)this.resizeWithResponse(size, null, null, Context.NONE).getValue();
    }

    public Response<PageBlobItem> resizeWithResponse(long size, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.resizeWithResponse(size, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public PageBlobItem updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        return (PageBlobItem)this.updateSequenceNumberWithResponse(action, sequenceNumber, null, null, Context.NONE).getValue();
    }

    public Response<PageBlobItem> updateSequenceNumberWithResponse(SequenceNumberActionType action, Long sequenceNumber, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.updateSequenceNumberWithResponse(action, sequenceNumber, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public CopyStatusType copyIncremental(String source, String snapshot) {
        return (CopyStatusType)((Object)this.copyIncrementalWithResponse(source, snapshot, null, null, Context.NONE).getValue());
    }

    public Response<CopyStatusType> copyIncrementalWithResponse(String source, String snapshot, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.copyIncrementalWithResponse(new PageBlobCopyIncrementalOptions(source, snapshot).setRequestConditions(ModelHelper.populateBlobDestinationRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    public Response<CopyStatusType> copyIncrementalWithResponse(PageBlobCopyIncrementalOptions options, Duration timeout, Context context) {
        Mono<Response<CopyStatusType>> response = this.pageBlobAsyncClient.copyIncrementalWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }
}

